package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "fileName", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class EducationFileSynchronizationVerificationMessage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("description")
    protected String description;

    protected EducationFileSynchronizationVerificationMessage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationFileSynchronizationVerificationMessage";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public EducationFileSynchronizationVerificationMessage withType(String type) {
        EducationFileSynchronizationVerificationMessage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFileSynchronizationVerificationMessage");
        _x.type = type;
        return _x;
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public EducationFileSynchronizationVerificationMessage withFileName(String fileName) {
        EducationFileSynchronizationVerificationMessage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFileSynchronizationVerificationMessage");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationFileSynchronizationVerificationMessage withDescription(String description) {
        EducationFileSynchronizationVerificationMessage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFileSynchronizationVerificationMessage");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String type;
        private String fileName;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public EducationFileSynchronizationVerificationMessage build() {
            EducationFileSynchronizationVerificationMessage _x = new EducationFileSynchronizationVerificationMessage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationFileSynchronizationVerificationMessage";
            _x.type = type;
            _x.fileName = fileName;
            _x.description = description;
            return _x;
        }
    }

    private EducationFileSynchronizationVerificationMessage _copy() {
        EducationFileSynchronizationVerificationMessage _x = new EducationFileSynchronizationVerificationMessage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.fileName = fileName;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationFileSynchronizationVerificationMessage[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
