package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "text", 
    "feedbackDateTime", 
    "feedbackBy"})
@JsonInclude(Include.NON_NULL)
public class EducationFeedback implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("text")
    protected EducationItemBody text;

    @JsonProperty("feedbackDateTime")
    protected OffsetDateTime feedbackDateTime;

    @JsonProperty("feedbackBy")
    protected IdentitySet feedbackBy;

    protected EducationFeedback() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationFeedback";
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<EducationItemBody> getText() {
        return Optional.ofNullable(text);
    }

    public EducationFeedback withText(EducationItemBody text) {
        EducationFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFeedback");
        _x.text = text;
        return _x;
    }

    @Property(name="feedbackDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFeedbackDateTime() {
        return Optional.ofNullable(feedbackDateTime);
    }

    public EducationFeedback withFeedbackDateTime(OffsetDateTime feedbackDateTime) {
        EducationFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFeedback");
        _x.feedbackDateTime = feedbackDateTime;
        return _x;
    }

    @Property(name="feedbackBy")
    @JsonIgnore
    public Optional<IdentitySet> getFeedbackBy() {
        return Optional.ofNullable(feedbackBy);
    }

    public EducationFeedback withFeedbackBy(IdentitySet feedbackBy) {
        EducationFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFeedback");
        _x.feedbackBy = feedbackBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationItemBody text;
        private OffsetDateTime feedbackDateTime;
        private IdentitySet feedbackBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder text(EducationItemBody text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder feedbackDateTime(OffsetDateTime feedbackDateTime) {
            this.feedbackDateTime = feedbackDateTime;
            this.changedFields = changedFields.add("feedbackDateTime");
            return this;
        }

        public Builder feedbackBy(IdentitySet feedbackBy) {
            this.feedbackBy = feedbackBy;
            this.changedFields = changedFields.add("feedbackBy");
            return this;
        }

        public EducationFeedback build() {
            EducationFeedback _x = new EducationFeedback();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationFeedback";
            _x.text = text;
            _x.feedbackDateTime = feedbackDateTime;
            _x.feedbackBy = feedbackBy;
            return _x;
        }
    }

    private EducationFeedback _copy() {
        EducationFeedback _x = new EducationFeedback();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.text = text;
        _x.feedbackDateTime = feedbackDateTime;
        _x.feedbackBy = feedbackBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationFeedback[");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("feedbackDateTime=");
        b.append(this.feedbackDateTime);
        b.append(", ");
        b.append("feedbackBy=");
        b.append(this.feedbackBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
