package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "subject", 
    "courseNumber", 
    "description", 
    "displayName", 
    "externalId"})
@JsonInclude(Include.NON_NULL)
public class EducationCourse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("courseNumber")
    protected String courseNumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalId")
    protected String externalId;

    protected EducationCourse() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationCourse";
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public EducationCourse withSubject(String subject) {
        EducationCourse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationCourse");
        _x.subject = subject;
        return _x;
    }

    @Property(name="courseNumber")
    @JsonIgnore
    public Optional<String> getCourseNumber() {
        return Optional.ofNullable(courseNumber);
    }

    public EducationCourse withCourseNumber(String courseNumber) {
        EducationCourse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationCourse");
        _x.courseNumber = courseNumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationCourse withDescription(String description) {
        EducationCourse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationCourse");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationCourse withDisplayName(String displayName) {
        EducationCourse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationCourse");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationCourse withExternalId(String externalId) {
        EducationCourse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationCourse");
        _x.externalId = externalId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String subject;
        private String courseNumber;
        private String description;
        private String displayName;
        private String externalId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder courseNumber(String courseNumber) {
            this.courseNumber = courseNumber;
            this.changedFields = changedFields.add("courseNumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public EducationCourse build() {
            EducationCourse _x = new EducationCourse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationCourse";
            _x.subject = subject;
            _x.courseNumber = courseNumber;
            _x.description = description;
            _x.displayName = displayName;
            _x.externalId = externalId;
            return _x;
        }
    }

    private EducationCourse _copy() {
        EducationCourse _x = new EducationCourse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.subject = subject;
        _x.courseNumber = courseNumber;
        _x.description = description;
        _x.displayName = displayName;
        _x.externalId = externalId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationCourse[");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("courseNumber=");
        b.append(this.courseNumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
