package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "points"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignmentPointsGrade extends EducationAssignmentGrade implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("points")
    protected Float points;

    protected EducationAssignmentPointsGrade() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignmentPointsGrade";
    }

    @Property(name="points")
    @JsonIgnore
    public Optional<Float> getPoints() {
        return Optional.ofNullable(points);
    }

    public EducationAssignmentPointsGrade withPoints(Float points) {
        EducationAssignmentPointsGrade _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentPointsGrade");
        _x.points = points;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignmentPointsGrade() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet gradedBy;
        private OffsetDateTime gradedDateTime;
        private Float points;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder gradedBy(IdentitySet gradedBy) {
            this.gradedBy = gradedBy;
            this.changedFields = changedFields.add("gradedBy");
            return this;
        }

        public Builder gradedDateTime(OffsetDateTime gradedDateTime) {
            this.gradedDateTime = gradedDateTime;
            this.changedFields = changedFields.add("gradedDateTime");
            return this;
        }

        public Builder points(Float points) {
            this.points = points;
            this.changedFields = changedFields.add("points");
            return this;
        }

        public EducationAssignmentPointsGrade build() {
            EducationAssignmentPointsGrade _x = new EducationAssignmentPointsGrade();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationAssignmentPointsGrade";
            _x.gradedBy = gradedBy;
            _x.gradedDateTime = gradedDateTime;
            _x.points = points;
            return _x;
        }
    }

    private EducationAssignmentPointsGrade _copy() {
        EducationAssignmentPointsGrade _x = new EducationAssignmentPointsGrade();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.gradedBy = gradedBy;
        _x.gradedDateTime = gradedDateTime;
        _x.points = points;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignmentPointsGrade[");
        b.append("gradedBy=");
        b.append(this.gradedBy);
        b.append(", ");
        b.append("gradedDateTime=");
        b.append(this.gradedDateTime);
        b.append(", ");
        b.append("points=");
        b.append(this.points);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
