package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "gradedBy", 
    "gradedDateTime"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignmentGrade implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("gradedBy")
    protected IdentitySet gradedBy;

    @JsonProperty("gradedDateTime")
    protected OffsetDateTime gradedDateTime;

    protected EducationAssignmentGrade() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignmentGrade";
    }

    @Property(name="gradedBy")
    @JsonIgnore
    public Optional<IdentitySet> getGradedBy() {
        return Optional.ofNullable(gradedBy);
    }

    public EducationAssignmentGrade withGradedBy(IdentitySet gradedBy) {
        EducationAssignmentGrade _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentGrade");
        _x.gradedBy = gradedBy;
        return _x;
    }

    @Property(name="gradedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getGradedDateTime() {
        return Optional.ofNullable(gradedDateTime);
    }

    public EducationAssignmentGrade withGradedDateTime(OffsetDateTime gradedDateTime) {
        EducationAssignmentGrade _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentGrade");
        _x.gradedDateTime = gradedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private EducationAssignmentGrade _copy() {
        EducationAssignmentGrade _x = new EducationAssignmentGrade();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.gradedBy = gradedBy;
        _x.gradedDateTime = gradedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignmentGrade[");
        b.append("gradedBy=");
        b.append(this.gradedBy);
        b.append(", ");
        b.append("gradedDateTime=");
        b.append(this.gradedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
