package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Allows IT admins to set a custom default search engine for MDM-Controlled
 * devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "edgeSearchEngineOpenSearchXmlUrl"})
@JsonInclude(Include.NON_NULL)
public class EdgeSearchEngineCustom extends EdgeSearchEngineBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("edgeSearchEngineOpenSearchXmlUrl")
    protected String edgeSearchEngineOpenSearchXmlUrl;

    protected EdgeSearchEngineCustom() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.edgeSearchEngineCustom";
    }

    /**
     * <i>“Points to a https link containing the OpenSearch xml file that contains, at
     * minimum, the short name and the URL to the search Engine.”</i>
     * 
     * @return property edgeSearchEngineOpenSearchXmlUrl
     */
    @Property(name="edgeSearchEngineOpenSearchXmlUrl")
    @JsonIgnore
    public Optional<String> getEdgeSearchEngineOpenSearchXmlUrl() {
        return Optional.ofNullable(edgeSearchEngineOpenSearchXmlUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeSearchEngineOpenSearchXmlUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Points to a https link containing the OpenSearch xml file that contains, at
     * minimum, the short name and the URL to the search Engine.”</i>
     * 
     * @param edgeSearchEngineOpenSearchXmlUrl
     *            new value of {@code edgeSearchEngineOpenSearchXmlUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeSearchEngineOpenSearchXmlUrl} field changed
     */
    public EdgeSearchEngineCustom withEdgeSearchEngineOpenSearchXmlUrl(String edgeSearchEngineOpenSearchXmlUrl) {
        EdgeSearchEngineCustom _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.edgeSearchEngineCustom");
        _x.edgeSearchEngineOpenSearchXmlUrl = edgeSearchEngineOpenSearchXmlUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEdgeSearchEngineCustom() {
        return new Builder();
    }

    public static final class Builder {
        private String edgeSearchEngineOpenSearchXmlUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Points to a https link containing the OpenSearch xml file that contains, at
         * minimum, the short name and the URL to the search Engine.”</i>
         * 
         * @param edgeSearchEngineOpenSearchXmlUrl
         *            value of {@code edgeSearchEngineOpenSearchXmlUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeSearchEngineOpenSearchXmlUrl(String edgeSearchEngineOpenSearchXmlUrl) {
            this.edgeSearchEngineOpenSearchXmlUrl = edgeSearchEngineOpenSearchXmlUrl;
            this.changedFields = changedFields.add("edgeSearchEngineOpenSearchXmlUrl");
            return this;
        }

        public EdgeSearchEngineCustom build() {
            EdgeSearchEngineCustom _x = new EdgeSearchEngineCustom();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.edgeSearchEngineCustom";
            _x.edgeSearchEngineOpenSearchXmlUrl = edgeSearchEngineOpenSearchXmlUrl;
            return _x;
        }
    }

    private EdgeSearchEngineCustom _copy() {
        EdgeSearchEngineCustom _x = new EdgeSearchEngineCustom();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.edgeSearchEngineOpenSearchXmlUrl = edgeSearchEngineOpenSearchXmlUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EdgeSearchEngineCustom[");
        b.append("edgeSearchEngineOpenSearchXmlUrl=");
        b.append(this.edgeSearchEngineOpenSearchXmlUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
