package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "alias", 
    "email", 
    "objectId"})
@JsonInclude(Include.NON_NULL)
public class DriveRecipient implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("alias")
    protected String alias;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("objectId")
    protected String objectId;

    protected DriveRecipient() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.driveRecipient";
    }

    @Property(name="alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    public DriveRecipient withAlias(String alias) {
        DriveRecipient _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveRecipient");
        _x.alias = alias;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public DriveRecipient withEmail(String email) {
        DriveRecipient _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveRecipient");
        _x.email = email;
        return _x;
    }

    @Property(name="objectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public DriveRecipient withObjectId(String objectId) {
        DriveRecipient _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveRecipient");
        _x.objectId = objectId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String alias;
        private String email;
        private String objectId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = changedFields.add("alias");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("objectId");
            return this;
        }

        public DriveRecipient build() {
            DriveRecipient _x = new DriveRecipient();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.driveRecipient";
            _x.alias = alias;
            _x.email = email;
            _x.objectId = objectId;
            return _x;
        }
    }

    private DriveRecipient _copy() {
        DriveRecipient _x = new DriveRecipient();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.alias = alias;
        _x.email = email;
        _x.objectId = objectId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DriveRecipient[");
        b.append("alias=");
        b.append(this.alias);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("objectId=");
        b.append(this.objectId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
