package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "justificationMessage", 
    "isDowngradeJustified"})
@JsonInclude(Include.NON_NULL)
public class DowngradeJustification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("justificationMessage")
    protected String justificationMessage;

    @JsonProperty("isDowngradeJustified")
    protected Boolean isDowngradeJustified;

    protected DowngradeJustification() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.downgradeJustification";
    }

    @Property(name="justificationMessage")
    @JsonIgnore
    public Optional<String> getJustificationMessage() {
        return Optional.ofNullable(justificationMessage);
    }

    public DowngradeJustification withJustificationMessage(String justificationMessage) {
        DowngradeJustification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.downgradeJustification");
        _x.justificationMessage = justificationMessage;
        return _x;
    }

    @Property(name="isDowngradeJustified")
    @JsonIgnore
    public Optional<Boolean> getIsDowngradeJustified() {
        return Optional.ofNullable(isDowngradeJustified);
    }

    public DowngradeJustification withIsDowngradeJustified(Boolean isDowngradeJustified) {
        DowngradeJustification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.downgradeJustification");
        _x.isDowngradeJustified = isDowngradeJustified;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String justificationMessage;
        private Boolean isDowngradeJustified;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder justificationMessage(String justificationMessage) {
            this.justificationMessage = justificationMessage;
            this.changedFields = changedFields.add("justificationMessage");
            return this;
        }

        public Builder isDowngradeJustified(Boolean isDowngradeJustified) {
            this.isDowngradeJustified = isDowngradeJustified;
            this.changedFields = changedFields.add("isDowngradeJustified");
            return this;
        }

        public DowngradeJustification build() {
            DowngradeJustification _x = new DowngradeJustification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.downgradeJustification";
            _x.justificationMessage = justificationMessage;
            _x.isDowngradeJustified = isDowngradeJustified;
            return _x;
        }
    }

    private DowngradeJustification _copy() {
        DowngradeJustification _x = new DowngradeJustification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.justificationMessage = justificationMessage;
        _x.isDowngradeJustified = isDowngradeJustified;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DowngradeJustification[");
        b.append("justificationMessage=");
        b.append(this.justificationMessage);
        b.append(", ");
        b.append("isDowngradeJustified=");
        b.append(this.isDowngradeJustified);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
