package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "operation", 
    "lastActionDateTime"})
@JsonInclude(Include.NON_NULL)
public class DomainState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("operation")
    protected String operation;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    protected DomainState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainState";
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public DomainState withStatus(String status) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.status = status;
        return _x;
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<String> getOperation() {
        return Optional.ofNullable(operation);
    }

    public DomainState withOperation(String operation) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.operation = operation;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public DomainState withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String status;
        private String operation;
        private OffsetDateTime lastActionDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public DomainState build() {
            DomainState _x = new DomainState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.domainState";
            _x.status = status;
            _x.operation = operation;
            _x.lastActionDateTime = lastActionDateTime;
            return _x;
        }
    }

    private DomainState _copy() {
        DomainState _x = new DomainState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.status = status;
        _x.operation = operation;
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainState[");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
