package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "domainName", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class DomainIdentitySource extends IdentitySource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("displayName")
    protected String displayName;

    protected DomainIdentitySource() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainIdentitySource";
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public DomainIdentitySource withDomainName(String domainName) {
        DomainIdentitySource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainIdentitySource");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DomainIdentitySource withDisplayName(String displayName) {
        DomainIdentitySource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainIdentitySource");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomainIdentitySource() {
        return new Builder();
    }

    public static final class Builder {
        private String domainName;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public DomainIdentitySource build() {
            DomainIdentitySource _x = new DomainIdentitySource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.domainIdentitySource";
            _x.domainName = domainName;
            _x.displayName = displayName;
            return _x;
        }
    }

    private DomainIdentitySource _copy() {
        DomainIdentitySource _x = new DomainIdentitySource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.domainName = domainName;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainIdentitySource[");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
