package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastModfiedBy", 
    "contentName"})
@JsonInclude(Include.NON_NULL)
public class DlpWindowsDevicesNotification extends DlpNotification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("lastModfiedBy")
    protected String lastModfiedBy;

    @JsonProperty("contentName")
    protected String contentName;

    protected DlpWindowsDevicesNotification() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpWindowsDevicesNotification";
    }

    @Property(name="lastModfiedBy")
    @JsonIgnore
    public Optional<String> getLastModfiedBy() {
        return Optional.ofNullable(lastModfiedBy);
    }

    public DlpWindowsDevicesNotification withLastModfiedBy(String lastModfiedBy) {
        DlpWindowsDevicesNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpWindowsDevicesNotification");
        _x.lastModfiedBy = lastModfiedBy;
        return _x;
    }

    @Property(name="contentName")
    @JsonIgnore
    public Optional<String> getContentName() {
        return Optional.ofNullable(contentName);
    }

    public DlpWindowsDevicesNotification withContentName(String contentName) {
        DlpWindowsDevicesNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpWindowsDevicesNotification");
        _x.contentName = contentName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDlpWindowsDevicesNotification() {
        return new Builder();
    }

    public static final class Builder {
        private String author;
        private String lastModfiedBy;
        private String contentName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder author(String author) {
            this.author = author;
            this.changedFields = changedFields.add("author");
            return this;
        }

        public Builder lastModfiedBy(String lastModfiedBy) {
            this.lastModfiedBy = lastModfiedBy;
            this.changedFields = changedFields.add("lastModfiedBy");
            return this;
        }

        public Builder contentName(String contentName) {
            this.contentName = contentName;
            this.changedFields = changedFields.add("contentName");
            return this;
        }

        public DlpWindowsDevicesNotification build() {
            DlpWindowsDevicesNotification _x = new DlpWindowsDevicesNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dlpWindowsDevicesNotification";
            _x.author = author;
            _x.lastModfiedBy = lastModfiedBy;
            _x.contentName = contentName;
            return _x;
        }
    }

    private DlpWindowsDevicesNotification _copy() {
        DlpWindowsDevicesNotification _x = new DlpWindowsDevicesNotification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.author = author;
        _x.lastModfiedBy = lastModfiedBy;
        _x.contentName = contentName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpWindowsDevicesNotification[");
        b.append("author=");
        b.append(this.author);
        b.append(", ");
        b.append("lastModfiedBy=");
        b.append(this.lastModfiedBy);
        b.append(", ");
        b.append("contentName=");
        b.append(this.contentName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
