package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "matchingRules"})
@JsonInclude(Include.NON_NULL)
public class DlpPoliciesJobResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("matchingRules")
    protected List<MatchingDlpRule> matchingRules;

    @JsonProperty("matchingRules@nextLink")
    protected String matchingRulesNextLink;

    protected DlpPoliciesJobResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpPoliciesJobResult";
    }

    @Property(name="matchingRules")
    @JsonIgnore
    public CollectionPage<MatchingDlpRule> getMatchingRules() {
        return new CollectionPage<MatchingDlpRule>(contextPath, MatchingDlpRule.class, matchingRules, Optional.ofNullable(matchingRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matchingRules")
    @JsonIgnore
    public CollectionPage<MatchingDlpRule> getMatchingRules(HttpRequestOptions options) {
        return new CollectionPage<MatchingDlpRule>(contextPath, MatchingDlpRule.class, matchingRules, Optional.ofNullable(matchingRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MatchingDlpRule> matchingRules;
        private String matchingRulesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder matchingRules(List<MatchingDlpRule> matchingRules) {
            this.matchingRules = matchingRules;
            this.changedFields = changedFields.add("matchingRules");
            return this;
        }

        public Builder matchingRules(MatchingDlpRule... matchingRules) {
            return matchingRules(Arrays.asList(matchingRules));
        }

        public Builder matchingRulesNextLink(String matchingRulesNextLink) {
            this.matchingRulesNextLink = matchingRulesNextLink;
            this.changedFields = changedFields.add("matchingRules");
            return this;
        }

        public DlpPoliciesJobResult build() {
            DlpPoliciesJobResult _x = new DlpPoliciesJobResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dlpPoliciesJobResult";
            _x.matchingRules = matchingRules;
            _x.matchingRulesNextLink = matchingRulesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpPoliciesJobResult[");
        b.append("matchingRules=");
        b.append(this.matchingRules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
