package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccessScope;

@JsonPropertyOrder({
    "@odata.type", 
    "contentProperties", 
    "sharedBy"})
@JsonInclude(Include.NON_NULL)
public class DlpEvaluationWindowsDevicesInput extends DlpEvaluationInput implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("contentProperties")
    protected ContentProperties contentProperties;

    @JsonProperty("sharedBy")
    protected String sharedBy;

    protected DlpEvaluationWindowsDevicesInput() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpEvaluationWindowsDevicesInput";
    }

    @Property(name="contentProperties")
    @JsonIgnore
    public Optional<ContentProperties> getContentProperties() {
        return Optional.ofNullable(contentProperties);
    }

    public DlpEvaluationWindowsDevicesInput withContentProperties(ContentProperties contentProperties) {
        DlpEvaluationWindowsDevicesInput _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluationWindowsDevicesInput");
        _x.contentProperties = contentProperties;
        return _x;
    }

    @Property(name="sharedBy")
    @JsonIgnore
    public Optional<String> getSharedBy() {
        return Optional.ofNullable(sharedBy);
    }

    public DlpEvaluationWindowsDevicesInput withSharedBy(String sharedBy) {
        DlpEvaluationWindowsDevicesInput _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluationWindowsDevicesInput");
        _x.sharedBy = sharedBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDlpEvaluationWindowsDevicesInput() {
        return new Builder();
    }

    public static final class Builder {
        private List<DiscoveredSensitiveType> discoveredSensitiveTypes;
        private String discoveredSensitiveTypesNextLink;
        private CurrentLabel currentLabel;
        private AccessScope accessScope;
        private ContentProperties contentProperties;
        private String sharedBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder discoveredSensitiveTypes(List<DiscoveredSensitiveType> discoveredSensitiveTypes) {
            this.discoveredSensitiveTypes = discoveredSensitiveTypes;
            this.changedFields = changedFields.add("discoveredSensitiveTypes");
            return this;
        }

        public Builder discoveredSensitiveTypes(DiscoveredSensitiveType... discoveredSensitiveTypes) {
            return discoveredSensitiveTypes(Arrays.asList(discoveredSensitiveTypes));
        }

        public Builder discoveredSensitiveTypesNextLink(String discoveredSensitiveTypesNextLink) {
            this.discoveredSensitiveTypesNextLink = discoveredSensitiveTypesNextLink;
            this.changedFields = changedFields.add("discoveredSensitiveTypes");
            return this;
        }

        public Builder currentLabel(CurrentLabel currentLabel) {
            this.currentLabel = currentLabel;
            this.changedFields = changedFields.add("currentLabel");
            return this;
        }

        public Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            this.changedFields = changedFields.add("accessScope");
            return this;
        }

        public Builder contentProperties(ContentProperties contentProperties) {
            this.contentProperties = contentProperties;
            this.changedFields = changedFields.add("contentProperties");
            return this;
        }

        public Builder sharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
            this.changedFields = changedFields.add("sharedBy");
            return this;
        }

        public DlpEvaluationWindowsDevicesInput build() {
            DlpEvaluationWindowsDevicesInput _x = new DlpEvaluationWindowsDevicesInput();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dlpEvaluationWindowsDevicesInput";
            _x.discoveredSensitiveTypes = discoveredSensitiveTypes;
            _x.discoveredSensitiveTypesNextLink = discoveredSensitiveTypesNextLink;
            _x.currentLabel = currentLabel;
            _x.accessScope = accessScope;
            _x.contentProperties = contentProperties;
            _x.sharedBy = sharedBy;
            return _x;
        }
    }

    private DlpEvaluationWindowsDevicesInput _copy() {
        DlpEvaluationWindowsDevicesInput _x = new DlpEvaluationWindowsDevicesInput();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.discoveredSensitiveTypes = discoveredSensitiveTypes;
        _x.currentLabel = currentLabel;
        _x.accessScope = accessScope;
        _x.contentProperties = contentProperties;
        _x.sharedBy = sharedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpEvaluationWindowsDevicesInput[");
        b.append("discoveredSensitiveTypes=");
        b.append(this.discoveredSensitiveTypes);
        b.append(", ");
        b.append("currentLabel=");
        b.append(this.currentLabel);
        b.append(", ");
        b.append("accessScope=");
        b.append(this.accessScope);
        b.append(", ");
        b.append("contentProperties=");
        b.append(this.contentProperties);
        b.append(", ");
        b.append("sharedBy=");
        b.append(this.sharedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
