package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccessScope;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "discoveredSensitiveTypes", 
    "currentLabel", 
    "accessScope"})
@JsonInclude(Include.NON_NULL)
public class DlpEvaluationInput implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("discoveredSensitiveTypes")
    protected List<DiscoveredSensitiveType> discoveredSensitiveTypes;

    @JsonProperty("discoveredSensitiveTypes@nextLink")
    protected String discoveredSensitiveTypesNextLink;

    @JsonProperty("currentLabel")
    protected CurrentLabel currentLabel;

    @JsonProperty("accessScope")
    protected AccessScope accessScope;

    protected DlpEvaluationInput() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpEvaluationInput";
    }

    @Property(name="discoveredSensitiveTypes")
    @JsonIgnore
    public CollectionPage<DiscoveredSensitiveType> getDiscoveredSensitiveTypes() {
        return new CollectionPage<DiscoveredSensitiveType>(contextPath, DiscoveredSensitiveType.class, discoveredSensitiveTypes, Optional.ofNullable(discoveredSensitiveTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="discoveredSensitiveTypes")
    @JsonIgnore
    public CollectionPage<DiscoveredSensitiveType> getDiscoveredSensitiveTypes(HttpRequestOptions options) {
        return new CollectionPage<DiscoveredSensitiveType>(contextPath, DiscoveredSensitiveType.class, discoveredSensitiveTypes, Optional.ofNullable(discoveredSensitiveTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="currentLabel")
    @JsonIgnore
    public Optional<CurrentLabel> getCurrentLabel() {
        return Optional.ofNullable(currentLabel);
    }

    public DlpEvaluationInput withCurrentLabel(CurrentLabel currentLabel) {
        DlpEvaluationInput _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluationInput");
        _x.currentLabel = currentLabel;
        return _x;
    }

    @Property(name="accessScope")
    @JsonIgnore
    public Optional<AccessScope> getAccessScope() {
        return Optional.ofNullable(accessScope);
    }

    public DlpEvaluationInput withAccessScope(AccessScope accessScope) {
        DlpEvaluationInput _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluationInput");
        _x.accessScope = accessScope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DiscoveredSensitiveType> discoveredSensitiveTypes;
        private String discoveredSensitiveTypesNextLink;
        private CurrentLabel currentLabel;
        private AccessScope accessScope;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder discoveredSensitiveTypes(List<DiscoveredSensitiveType> discoveredSensitiveTypes) {
            this.discoveredSensitiveTypes = discoveredSensitiveTypes;
            this.changedFields = changedFields.add("discoveredSensitiveTypes");
            return this;
        }

        public Builder discoveredSensitiveTypes(DiscoveredSensitiveType... discoveredSensitiveTypes) {
            return discoveredSensitiveTypes(Arrays.asList(discoveredSensitiveTypes));
        }

        public Builder discoveredSensitiveTypesNextLink(String discoveredSensitiveTypesNextLink) {
            this.discoveredSensitiveTypesNextLink = discoveredSensitiveTypesNextLink;
            this.changedFields = changedFields.add("discoveredSensitiveTypes");
            return this;
        }

        public Builder currentLabel(CurrentLabel currentLabel) {
            this.currentLabel = currentLabel;
            this.changedFields = changedFields.add("currentLabel");
            return this;
        }

        public Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            this.changedFields = changedFields.add("accessScope");
            return this;
        }

        public DlpEvaluationInput build() {
            DlpEvaluationInput _x = new DlpEvaluationInput();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dlpEvaluationInput";
            _x.discoveredSensitiveTypes = discoveredSensitiveTypes;
            _x.discoveredSensitiveTypesNextLink = discoveredSensitiveTypesNextLink;
            _x.currentLabel = currentLabel;
            _x.accessScope = accessScope;
            return _x;
        }
    }

    private DlpEvaluationInput _copy() {
        DlpEvaluationInput _x = new DlpEvaluationInput();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.discoveredSensitiveTypes = discoveredSensitiveTypes;
        _x.currentLabel = currentLabel;
        _x.accessScope = accessScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpEvaluationInput[");
        b.append("discoveredSensitiveTypes=");
        b.append(this.discoveredSensitiveTypes);
        b.append(", ");
        b.append("currentLabel=");
        b.append(this.currentLabel);
        b.append(", ");
        b.append("accessScope=");
        b.append(this.accessScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
