package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "target", 
    "evaluationInput", 
    "notificationInfo"})
@JsonInclude(Include.NON_NULL)
public class DlpEvaluatePoliciesRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("target")
    protected String target;

    @JsonProperty("evaluationInput")
    protected DlpEvaluationInput evaluationInput;

    @JsonProperty("notificationInfo")
    protected DlpNotification notificationInfo;

    protected DlpEvaluatePoliciesRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpEvaluatePoliciesRequest";
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public DlpEvaluatePoliciesRequest withTarget(String target) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.target = target;
        return _x;
    }

    @Property(name="evaluationInput")
    @JsonIgnore
    public Optional<DlpEvaluationInput> getEvaluationInput() {
        return Optional.ofNullable(evaluationInput);
    }

    public DlpEvaluatePoliciesRequest withEvaluationInput(DlpEvaluationInput evaluationInput) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.evaluationInput = evaluationInput;
        return _x;
    }

    @Property(name="notificationInfo")
    @JsonIgnore
    public Optional<DlpNotification> getNotificationInfo() {
        return Optional.ofNullable(notificationInfo);
    }

    public DlpEvaluatePoliciesRequest withNotificationInfo(DlpNotification notificationInfo) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.notificationInfo = notificationInfo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String target;
        private DlpEvaluationInput evaluationInput;
        private DlpNotification notificationInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder evaluationInput(DlpEvaluationInput evaluationInput) {
            this.evaluationInput = evaluationInput;
            this.changedFields = changedFields.add("evaluationInput");
            return this;
        }

        public Builder notificationInfo(DlpNotification notificationInfo) {
            this.notificationInfo = notificationInfo;
            this.changedFields = changedFields.add("notificationInfo");
            return this;
        }

        public DlpEvaluatePoliciesRequest build() {
            DlpEvaluatePoliciesRequest _x = new DlpEvaluatePoliciesRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dlpEvaluatePoliciesRequest";
            _x.target = target;
            _x.evaluationInput = evaluationInput;
            _x.notificationInfo = notificationInfo;
            return _x;
        }
    }

    private DlpEvaluatePoliciesRequest _copy() {
        DlpEvaluatePoliciesRequest _x = new DlpEvaluatePoliciesRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.target = target;
        _x.evaluationInput = evaluationInput;
        _x.notificationInfo = notificationInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpEvaluatePoliciesRequest[");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("evaluationInput=");
        b.append(this.evaluationInput);
        b.append(", ");
        b.append("notificationInfo=");
        b.append(this.notificationInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
