package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "languageTag", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class DisplayNameLocalization implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("displayName")
    protected String displayName;

    protected DisplayNameLocalization() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.displayNameLocalization";
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public DisplayNameLocalization withLanguageTag(String languageTag) {
        DisplayNameLocalization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.displayNameLocalization");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DisplayNameLocalization withDisplayName(String displayName) {
        DisplayNameLocalization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.displayNameLocalization");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String languageTag;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public DisplayNameLocalization build() {
            DisplayNameLocalization _x = new DisplayNameLocalization();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.displayNameLocalization";
            _x.languageTag = languageTag;
            _x.displayName = displayName;
            return _x;
        }
    }

    private DisplayNameLocalization _copy() {
        DisplayNameLocalization _x = new DisplayNameLocalization();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.languageTag = languageTag;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DisplayNameLocalization[");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
