package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "count", 
    "confidence"})
@JsonInclude(Include.NON_NULL)
public class DiscoveredSensitiveType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("confidence")
    protected Integer confidence;

    protected DiscoveredSensitiveType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.discoveredSensitiveType";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public DiscoveredSensitiveType withId(String id) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.id = id;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public DiscoveredSensitiveType withCount(Integer count) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.count = count;
        return _x;
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public DiscoveredSensitiveType withConfidence(Integer confidence) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.confidence = confidence;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer count;
        private Integer confidence;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public DiscoveredSensitiveType build() {
            DiscoveredSensitiveType _x = new DiscoveredSensitiveType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.discoveredSensitiveType";
            _x.id = id;
            _x.count = count;
            _x.confidence = confidence;
            return _x;
        }
    }

    private DiscoveredSensitiveType _copy() {
        DiscoveredSensitiveType _x = new DiscoveredSensitiveType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.count = count;
        _x.confidence = confidence;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DiscoveredSensitiveType[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
