package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.StateManagementSetting;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Represents a user rights setting.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "state", 
    "localUsersOrGroups"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementUserRightsSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("state")
    protected StateManagementSetting state;

    @JsonProperty("localUsersOrGroups")
    protected List<DeviceManagementUserRightsLocalUserOrGroup> localUsersOrGroups;

    @JsonProperty("localUsersOrGroups@nextLink")
    protected String localUsersOrGroupsNextLink;

    protected DeviceManagementUserRightsSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementUserRightsSetting";
    }

    /**
     * <i>“Representing the current state of this user rights setting”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<StateManagementSetting> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Representing the current state of this user rights setting”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceManagementUserRightsSetting withState(StateManagementSetting state) {
        DeviceManagementUserRightsSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementUserRightsSetting");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Representing a collection of local users or groups which will be set on device
     * if the state of this setting is Allowed. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property localUsersOrGroups
     */
    @Property(name="localUsersOrGroups")
    @JsonIgnore
    public CollectionPage<DeviceManagementUserRightsLocalUserOrGroup> getLocalUsersOrGroups() {
        return new CollectionPage<DeviceManagementUserRightsLocalUserOrGroup>(contextPath, DeviceManagementUserRightsLocalUserOrGroup.class, localUsersOrGroups, Optional.ofNullable(localUsersOrGroupsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Representing a collection of local users or groups which will be set on device
     * if the state of this setting is Allowed. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property localUsersOrGroups
     */
    @Property(name="localUsersOrGroups")
    @JsonIgnore
    public CollectionPage<DeviceManagementUserRightsLocalUserOrGroup> getLocalUsersOrGroups(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementUserRightsLocalUserOrGroup>(contextPath, DeviceManagementUserRightsLocalUserOrGroup.class, localUsersOrGroups, Optional.ofNullable(localUsersOrGroupsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StateManagementSetting state;
        private List<DeviceManagementUserRightsLocalUserOrGroup> localUsersOrGroups;
        private String localUsersOrGroupsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Representing the current state of this user rights setting”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(StateManagementSetting state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Representing a collection of local users or groups which will be set on device
         * if the state of this setting is Allowed. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param localUsersOrGroups
         *            value of {@code localUsersOrGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localUsersOrGroups(List<DeviceManagementUserRightsLocalUserOrGroup> localUsersOrGroups) {
            this.localUsersOrGroups = localUsersOrGroups;
            this.changedFields = changedFields.add("localUsersOrGroups");
            return this;
        }

        /**
         * <i>“Representing a collection of local users or groups which will be set on device
         * if the state of this setting is Allowed. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param localUsersOrGroups
         *            value of {@code localUsersOrGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localUsersOrGroups(DeviceManagementUserRightsLocalUserOrGroup... localUsersOrGroups) {
            return localUsersOrGroups(Arrays.asList(localUsersOrGroups));
        }

        /**
         * <i>“Representing a collection of local users or groups which will be set on device
         * if the state of this setting is Allowed. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param localUsersOrGroupsNextLink
         *            value of {@code localUsersOrGroups@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localUsersOrGroupsNextLink(String localUsersOrGroupsNextLink) {
            this.localUsersOrGroupsNextLink = localUsersOrGroupsNextLink;
            this.changedFields = changedFields.add("localUsersOrGroups");
            return this;
        }

        public DeviceManagementUserRightsSetting build() {
            DeviceManagementUserRightsSetting _x = new DeviceManagementUserRightsSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementUserRightsSetting";
            _x.state = state;
            _x.localUsersOrGroups = localUsersOrGroups;
            _x.localUsersOrGroupsNextLink = localUsersOrGroupsNextLink;
            return _x;
        }
    }

    private DeviceManagementUserRightsSetting _copy() {
        DeviceManagementUserRightsSetting _x = new DeviceManagementUserRightsSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.state = state;
        _x.localUsersOrGroups = localUsersOrGroups;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementUserRightsSetting[");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("localUsersOrGroups=");
        b.append(this.localUsersOrGroups);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
