package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Object representing a link to troubleshooting information, the link could be to
 * the Azure Portal or a Microsoft doc.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "text", 
    "link"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementTroubleshootingErrorResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("link")
    protected String link;

    protected DeviceManagementTroubleshootingErrorResource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementTroubleshootingErrorResource";
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public DeviceManagementTroubleshootingErrorResource withText(String text) {
        DeviceManagementTroubleshootingErrorResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorResource");
        _x.text = text;
        return _x;
    }

    /**
     * <i>“The link to the web resource. Can contain any of the following formatters: {{UPN
     * }}, {{DeviceGUID}}, {{UserGUID}}”</i>
     * 
     * @return property link
     */
    @Property(name="link")
    @JsonIgnore
    public Optional<String> getLink() {
        return Optional.ofNullable(link);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code link} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The link to the web resource. Can contain any of the following formatters: {{UPN
     * }}, {{DeviceGUID}}, {{UserGUID}}”</i>
     * 
     * @param link
     *            new value of {@code link} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code link} field changed
     */
    public DeviceManagementTroubleshootingErrorResource withLink(String link) {
        DeviceManagementTroubleshootingErrorResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorResource");
        _x.link = link;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String text;
        private String link;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        /**
         * <i>“The link to the web resource. Can contain any of the following formatters: {{UPN
         * }}, {{DeviceGUID}}, {{UserGUID}}”</i>
         * 
         * @param link
         *            value of {@code link} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder link(String link) {
            this.link = link;
            this.changedFields = changedFields.add("link");
            return this;
        }

        public DeviceManagementTroubleshootingErrorResource build() {
            DeviceManagementTroubleshootingErrorResource _x = new DeviceManagementTroubleshootingErrorResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementTroubleshootingErrorResource";
            _x.text = text;
            _x.link = link;
            return _x;
        }
    }

    private DeviceManagementTroubleshootingErrorResource _copy() {
        DeviceManagementTroubleshootingErrorResource _x = new DeviceManagementTroubleshootingErrorResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.text = text;
        _x.link = link;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementTroubleshootingErrorResource[");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("link=");
        b.append(this.link);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
