package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Object containing detailed information about the error and its remediation.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "context", 
    "failure", 
    "failureDetails", 
    "remediation", 
    "resources"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementTroubleshootingErrorDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("context")
    protected String context;

    @JsonProperty("failure")
    protected String failure;

    @JsonProperty("failureDetails")
    protected String failureDetails;

    @JsonProperty("remediation")
    protected String remediation;

    @JsonProperty("resources")
    protected List<DeviceManagementTroubleshootingErrorResource> resources;

    @JsonProperty("resources@nextLink")
    protected String resourcesNextLink;

    protected DeviceManagementTroubleshootingErrorDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementTroubleshootingErrorDetails";
    }

    @Property(name="context")
    @JsonIgnore
    public Optional<String> getContext() {
        return Optional.ofNullable(context);
    }

    public DeviceManagementTroubleshootingErrorDetails withContext(String context) {
        DeviceManagementTroubleshootingErrorDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorDetails");
        _x.context = context;
        return _x;
    }

    @Property(name="failure")
    @JsonIgnore
    public Optional<String> getFailure() {
        return Optional.ofNullable(failure);
    }

    public DeviceManagementTroubleshootingErrorDetails withFailure(String failure) {
        DeviceManagementTroubleshootingErrorDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorDetails");
        _x.failure = failure;
        return _x;
    }

    /**
     * <i>“The detailed description of what went wrong.”</i>
     * 
     * @return property failureDetails
     */
    @Property(name="failureDetails")
    @JsonIgnore
    public Optional<String> getFailureDetails() {
        return Optional.ofNullable(failureDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failureDetails}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The detailed description of what went wrong.”</i>
     * 
     * @param failureDetails
     *            new value of {@code failureDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failureDetails} field changed
     */
    public DeviceManagementTroubleshootingErrorDetails withFailureDetails(String failureDetails) {
        DeviceManagementTroubleshootingErrorDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorDetails");
        _x.failureDetails = failureDetails;
        return _x;
    }

    /**
     * <i>“The detailed description of how to remediate this issue.”</i>
     * 
     * @return property remediation
     */
    @Property(name="remediation")
    @JsonIgnore
    public Optional<String> getRemediation() {
        return Optional.ofNullable(remediation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remediation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The detailed description of how to remediate this issue.”</i>
     * 
     * @param remediation
     *            new value of {@code remediation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediation} field changed
     */
    public DeviceManagementTroubleshootingErrorDetails withRemediation(String remediation) {
        DeviceManagementTroubleshootingErrorDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingErrorDetails");
        _x.remediation = remediation;
        return _x;
    }

    /**
     * <i>“Links to helpful documentation about this failure.”</i>
     * 
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<DeviceManagementTroubleshootingErrorResource> getResources() {
        return new CollectionPage<DeviceManagementTroubleshootingErrorResource>(contextPath, DeviceManagementTroubleshootingErrorResource.class, resources, Optional.ofNullable(resourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Links to helpful documentation about this failure.”</i>
     * 
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<DeviceManagementTroubleshootingErrorResource> getResources(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementTroubleshootingErrorResource>(contextPath, DeviceManagementTroubleshootingErrorResource.class, resources, Optional.ofNullable(resourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String context;
        private String failure;
        private String failureDetails;
        private String remediation;
        private List<DeviceManagementTroubleshootingErrorResource> resources;
        private String resourcesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder context(String context) {
            this.context = context;
            this.changedFields = changedFields.add("context");
            return this;
        }

        public Builder failure(String failure) {
            this.failure = failure;
            this.changedFields = changedFields.add("failure");
            return this;
        }

        /**
         * <i>“The detailed description of what went wrong.”</i>
         * 
         * @param failureDetails
         *            value of {@code failureDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failureDetails(String failureDetails) {
            this.failureDetails = failureDetails;
            this.changedFields = changedFields.add("failureDetails");
            return this;
        }

        /**
         * <i>“The detailed description of how to remediate this issue.”</i>
         * 
         * @param remediation
         *            value of {@code remediation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediation(String remediation) {
            this.remediation = remediation;
            this.changedFields = changedFields.add("remediation");
            return this;
        }

        /**
         * <i>“Links to helpful documentation about this failure.”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(List<DeviceManagementTroubleshootingErrorResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        /**
         * <i>“Links to helpful documentation about this failure.”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(DeviceManagementTroubleshootingErrorResource... resources) {
            return resources(Arrays.asList(resources));
        }

        /**
         * <i>“Links to helpful documentation about this failure.”</i>
         * 
         * @param resourcesNextLink
         *            value of {@code resources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcesNextLink(String resourcesNextLink) {
            this.resourcesNextLink = resourcesNextLink;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public DeviceManagementTroubleshootingErrorDetails build() {
            DeviceManagementTroubleshootingErrorDetails _x = new DeviceManagementTroubleshootingErrorDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementTroubleshootingErrorDetails";
            _x.context = context;
            _x.failure = failure;
            _x.failureDetails = failureDetails;
            _x.remediation = remediation;
            _x.resources = resources;
            _x.resourcesNextLink = resourcesNextLink;
            return _x;
        }
    }

    private DeviceManagementTroubleshootingErrorDetails _copy() {
        DeviceManagementTroubleshootingErrorDetails _x = new DeviceManagementTroubleshootingErrorDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.context = context;
        _x.failure = failure;
        _x.failureDetails = failureDetails;
        _x.remediation = remediation;
        _x.resources = resources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementTroubleshootingErrorDetails[");
        b.append("context=");
        b.append(this.context);
        b.append(", ");
        b.append("failure=");
        b.append(this.failure);
        b.append(", ");
        b.append("failureDetails=");
        b.append(this.failureDetails);
        b.append(", ");
        b.append("remediation=");
        b.append(this.remediation);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
