package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DerivedCredentialProviderType;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceComplianceCheckinThresholdDays", 
    "isScheduledActionEnabled", 
    "secureByDefault", 
    "enhancedJailBreak", 
    "deviceInactivityBeforeRetirementInDay", 
    "derivedCredentialProvider", 
    "derivedCredentialUrl", 
    "androidDeviceAdministratorEnrollmentEnabled", 
    "ignoreDevicesForUnsupportedSettingsEnabled", 
    "enableLogCollection"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceComplianceCheckinThresholdDays")
    protected Integer deviceComplianceCheckinThresholdDays;

    @JsonProperty("isScheduledActionEnabled")
    protected Boolean isScheduledActionEnabled;

    @JsonProperty("secureByDefault")
    protected Boolean secureByDefault;

    @JsonProperty("enhancedJailBreak")
    protected Boolean enhancedJailBreak;

    @JsonProperty("deviceInactivityBeforeRetirementInDay")
    protected Integer deviceInactivityBeforeRetirementInDay;

    @JsonProperty("derivedCredentialProvider")
    protected DerivedCredentialProviderType derivedCredentialProvider;

    @JsonProperty("derivedCredentialUrl")
    protected String derivedCredentialUrl;

    @JsonProperty("androidDeviceAdministratorEnrollmentEnabled")
    protected Boolean androidDeviceAdministratorEnrollmentEnabled;

    @JsonProperty("ignoreDevicesForUnsupportedSettingsEnabled")
    protected Boolean ignoreDevicesForUnsupportedSettingsEnabled;

    @JsonProperty("enableLogCollection")
    protected Boolean enableLogCollection;

    protected DeviceManagementSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettings";
    }

    /**
     * <i>“The number of days a device is allowed to go without checking in to remain
     * compliant.”</i>
     * 
     * @return property deviceComplianceCheckinThresholdDays
     */
    @Property(name="deviceComplianceCheckinThresholdDays")
    @JsonIgnore
    public Optional<Integer> getDeviceComplianceCheckinThresholdDays() {
        return Optional.ofNullable(deviceComplianceCheckinThresholdDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceCheckinThresholdDays} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of days a device is allowed to go without checking in to remain
     * compliant.”</i>
     * 
     * @param deviceComplianceCheckinThresholdDays
     *            new value of {@code deviceComplianceCheckinThresholdDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceCheckinThresholdDays} field changed
     */
    public DeviceManagementSettings withDeviceComplianceCheckinThresholdDays(Integer deviceComplianceCheckinThresholdDays) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.deviceComplianceCheckinThresholdDays = deviceComplianceCheckinThresholdDays;
        return _x;
    }

    /**
     * <i>“Is feature enabled or not for scheduled action for rule.”</i>
     * 
     * @return property isScheduledActionEnabled
     */
    @Property(name="isScheduledActionEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsScheduledActionEnabled() {
        return Optional.ofNullable(isScheduledActionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isScheduledActionEnabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Is feature enabled or not for scheduled action for rule.”</i>
     * 
     * @param isScheduledActionEnabled
     *            new value of {@code isScheduledActionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isScheduledActionEnabled} field changed
     */
    public DeviceManagementSettings withIsScheduledActionEnabled(Boolean isScheduledActionEnabled) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.isScheduledActionEnabled = isScheduledActionEnabled;
        return _x;
    }

    /**
     * <i>“Device should be noncompliant when there is no compliance policy targeted when
     * this is true”</i>
     * 
     * @return property secureByDefault
     */
    @Property(name="secureByDefault")
    @JsonIgnore
    public Optional<Boolean> getSecureByDefault() {
        return Optional.ofNullable(secureByDefault);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secureByDefault}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device should be noncompliant when there is no compliance policy targeted when
     * this is true”</i>
     * 
     * @param secureByDefault
     *            new value of {@code secureByDefault} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureByDefault} field changed
     */
    public DeviceManagementSettings withSecureByDefault(Boolean secureByDefault) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.secureByDefault = secureByDefault;
        return _x;
    }

    /**
     * <i>“Is feature enabled or not for enhanced jailbreak detection.”</i>
     * 
     * @return property enhancedJailBreak
     */
    @Property(name="enhancedJailBreak")
    @JsonIgnore
    public Optional<Boolean> getEnhancedJailBreak() {
        return Optional.ofNullable(enhancedJailBreak);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enhancedJailBreak
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Is feature enabled or not for enhanced jailbreak detection.”</i>
     * 
     * @param enhancedJailBreak
     *            new value of {@code enhancedJailBreak} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enhancedJailBreak} field changed
     */
    public DeviceManagementSettings withEnhancedJailBreak(Boolean enhancedJailBreak) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.enhancedJailBreak = enhancedJailBreak;
        return _x;
    }

    /**
     * <i>“When the device does not check in for specified number of days, the company data
     * might be removed and the device will not be under management. Valid values 30 to
     * 270”</i>
     * 
     * @return property deviceInactivityBeforeRetirementInDay
     */
    @Property(name="deviceInactivityBeforeRetirementInDay")
    @JsonIgnore
    public Optional<Integer> getDeviceInactivityBeforeRetirementInDay() {
        return Optional.ofNullable(deviceInactivityBeforeRetirementInDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceInactivityBeforeRetirementInDay} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“When the device does not check in for specified number of days, the company data
     * might be removed and the device will not be under management. Valid values 30 to
     * 270”</i>
     * 
     * @param deviceInactivityBeforeRetirementInDay
     *            new value of {@code deviceInactivityBeforeRetirementInDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceInactivityBeforeRetirementInDay} field changed
     */
    public DeviceManagementSettings withDeviceInactivityBeforeRetirementInDay(Integer deviceInactivityBeforeRetirementInDay) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.deviceInactivityBeforeRetirementInDay = deviceInactivityBeforeRetirementInDay;
        return _x;
    }

    /**
     * <i>“The Derived Credential Provider to use for this account.”</i>
     * 
     * @return property derivedCredentialProvider
     */
    @Property(name="derivedCredentialProvider")
    @JsonIgnore
    public Optional<DerivedCredentialProviderType> getDerivedCredentialProvider() {
        return Optional.ofNullable(derivedCredentialProvider);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * derivedCredentialProvider} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Derived Credential Provider to use for this account.”</i>
     * 
     * @param derivedCredentialProvider
     *            new value of {@code derivedCredentialProvider} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code derivedCredentialProvider} field changed
     */
    public DeviceManagementSettings withDerivedCredentialProvider(DerivedCredentialProviderType derivedCredentialProvider) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.derivedCredentialProvider = derivedCredentialProvider;
        return _x;
    }

    /**
     * <i>“The Derived Credential Provider self-service URI.”</i>
     * 
     * @return property derivedCredentialUrl
     */
    @Property(name="derivedCredentialUrl")
    @JsonIgnore
    public Optional<String> getDerivedCredentialUrl() {
        return Optional.ofNullable(derivedCredentialUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * derivedCredentialUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Derived Credential Provider self-service URI.”</i>
     * 
     * @param derivedCredentialUrl
     *            new value of {@code derivedCredentialUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code derivedCredentialUrl} field changed
     */
    public DeviceManagementSettings withDerivedCredentialUrl(String derivedCredentialUrl) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.derivedCredentialUrl = derivedCredentialUrl;
        return _x;
    }

    /**
     * <i>“The property to determine if Android device administrator enrollment is enabled
     * for this account.”</i>
     * 
     * @return property androidDeviceAdministratorEnrollmentEnabled
     */
    @Property(name="androidDeviceAdministratorEnrollmentEnabled")
    @JsonIgnore
    public Optional<Boolean> getAndroidDeviceAdministratorEnrollmentEnabled() {
        return Optional.ofNullable(androidDeviceAdministratorEnrollmentEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDeviceAdministratorEnrollmentEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The property to determine if Android device administrator enrollment is enabled
     * for this account.”</i>
     * 
     * @param androidDeviceAdministratorEnrollmentEnabled
     *            new value of {@code androidDeviceAdministratorEnrollmentEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDeviceAdministratorEnrollmentEnabled} field changed
     */
    public DeviceManagementSettings withAndroidDeviceAdministratorEnrollmentEnabled(Boolean androidDeviceAdministratorEnrollmentEnabled) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.androidDeviceAdministratorEnrollmentEnabled = androidDeviceAdministratorEnrollmentEnabled;
        return _x;
    }

    /**
     * <i>“The property to determine whether to ignore unsupported compliance settings on
     * certian models of devices.”</i>
     * 
     * @return property ignoreDevicesForUnsupportedSettingsEnabled
     */
    @Property(name="ignoreDevicesForUnsupportedSettingsEnabled")
    @JsonIgnore
    public Optional<Boolean> getIgnoreDevicesForUnsupportedSettingsEnabled() {
        return Optional.ofNullable(ignoreDevicesForUnsupportedSettingsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ignoreDevicesForUnsupportedSettingsEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The property to determine whether to ignore unsupported compliance settings on
     * certian models of devices.”</i>
     * 
     * @param ignoreDevicesForUnsupportedSettingsEnabled
     *            new value of {@code ignoreDevicesForUnsupportedSettingsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ignoreDevicesForUnsupportedSettingsEnabled} field changed
     */
    public DeviceManagementSettings withIgnoreDevicesForUnsupportedSettingsEnabled(Boolean ignoreDevicesForUnsupportedSettingsEnabled) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.ignoreDevicesForUnsupportedSettingsEnabled = ignoreDevicesForUnsupportedSettingsEnabled;
        return _x;
    }

    /**
     * <i>“Determines whether the log collection feature should be available for use.”</i>
     * 
     * @return property enableLogCollection
     */
    @Property(name="enableLogCollection")
    @JsonIgnore
    public Optional<Boolean> getEnableLogCollection() {
        return Optional.ofNullable(enableLogCollection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableLogCollection} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determines whether the log collection feature should be available for use.”</i>
     * 
     * @param enableLogCollection
     *            new value of {@code enableLogCollection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableLogCollection} field changed
     */
    public DeviceManagementSettings withEnableLogCollection(Boolean enableLogCollection) {
        DeviceManagementSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettings");
        _x.enableLogCollection = enableLogCollection;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer deviceComplianceCheckinThresholdDays;
        private Boolean isScheduledActionEnabled;
        private Boolean secureByDefault;
        private Boolean enhancedJailBreak;
        private Integer deviceInactivityBeforeRetirementInDay;
        private DerivedCredentialProviderType derivedCredentialProvider;
        private String derivedCredentialUrl;
        private Boolean androidDeviceAdministratorEnrollmentEnabled;
        private Boolean ignoreDevicesForUnsupportedSettingsEnabled;
        private Boolean enableLogCollection;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of days a device is allowed to go without checking in to remain
         * compliant.”</i>
         * 
         * @param deviceComplianceCheckinThresholdDays
         *            value of {@code deviceComplianceCheckinThresholdDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceCheckinThresholdDays(Integer deviceComplianceCheckinThresholdDays) {
            this.deviceComplianceCheckinThresholdDays = deviceComplianceCheckinThresholdDays;
            this.changedFields = changedFields.add("deviceComplianceCheckinThresholdDays");
            return this;
        }

        /**
         * <i>“Is feature enabled or not for scheduled action for rule.”</i>
         * 
         * @param isScheduledActionEnabled
         *            value of {@code isScheduledActionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isScheduledActionEnabled(Boolean isScheduledActionEnabled) {
            this.isScheduledActionEnabled = isScheduledActionEnabled;
            this.changedFields = changedFields.add("isScheduledActionEnabled");
            return this;
        }

        /**
         * <i>“Device should be noncompliant when there is no compliance policy targeted when
         * this is true”</i>
         * 
         * @param secureByDefault
         *            value of {@code secureByDefault} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureByDefault(Boolean secureByDefault) {
            this.secureByDefault = secureByDefault;
            this.changedFields = changedFields.add("secureByDefault");
            return this;
        }

        /**
         * <i>“Is feature enabled or not for enhanced jailbreak detection.”</i>
         * 
         * @param enhancedJailBreak
         *            value of {@code enhancedJailBreak} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enhancedJailBreak(Boolean enhancedJailBreak) {
            this.enhancedJailBreak = enhancedJailBreak;
            this.changedFields = changedFields.add("enhancedJailBreak");
            return this;
        }

        /**
         * <i>“When the device does not check in for specified number of days, the company data
         * might be removed and the device will not be under management. Valid values 30 to
         * 270”</i>
         * 
         * @param deviceInactivityBeforeRetirementInDay
         *            value of {@code deviceInactivityBeforeRetirementInDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceInactivityBeforeRetirementInDay(Integer deviceInactivityBeforeRetirementInDay) {
            this.deviceInactivityBeforeRetirementInDay = deviceInactivityBeforeRetirementInDay;
            this.changedFields = changedFields.add("deviceInactivityBeforeRetirementInDay");
            return this;
        }

        /**
         * <i>“The Derived Credential Provider to use for this account.”</i>
         * 
         * @param derivedCredentialProvider
         *            value of {@code derivedCredentialProvider} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder derivedCredentialProvider(DerivedCredentialProviderType derivedCredentialProvider) {
            this.derivedCredentialProvider = derivedCredentialProvider;
            this.changedFields = changedFields.add("derivedCredentialProvider");
            return this;
        }

        /**
         * <i>“The Derived Credential Provider self-service URI.”</i>
         * 
         * @param derivedCredentialUrl
         *            value of {@code derivedCredentialUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder derivedCredentialUrl(String derivedCredentialUrl) {
            this.derivedCredentialUrl = derivedCredentialUrl;
            this.changedFields = changedFields.add("derivedCredentialUrl");
            return this;
        }

        /**
         * <i>“The property to determine if Android device administrator enrollment is enabled
         * for this account.”</i>
         * 
         * @param androidDeviceAdministratorEnrollmentEnabled
         *            value of {@code androidDeviceAdministratorEnrollmentEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceAdministratorEnrollmentEnabled(Boolean androidDeviceAdministratorEnrollmentEnabled) {
            this.androidDeviceAdministratorEnrollmentEnabled = androidDeviceAdministratorEnrollmentEnabled;
            this.changedFields = changedFields.add("androidDeviceAdministratorEnrollmentEnabled");
            return this;
        }

        /**
         * <i>“The property to determine whether to ignore unsupported compliance settings on
         * certian models of devices.”</i>
         * 
         * @param ignoreDevicesForUnsupportedSettingsEnabled
         *            value of {@code ignoreDevicesForUnsupportedSettingsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ignoreDevicesForUnsupportedSettingsEnabled(Boolean ignoreDevicesForUnsupportedSettingsEnabled) {
            this.ignoreDevicesForUnsupportedSettingsEnabled = ignoreDevicesForUnsupportedSettingsEnabled;
            this.changedFields = changedFields.add("ignoreDevicesForUnsupportedSettingsEnabled");
            return this;
        }

        /**
         * <i>“Determines whether the log collection feature should be available for use.”</i>
         * 
         * @param enableLogCollection
         *            value of {@code enableLogCollection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableLogCollection(Boolean enableLogCollection) {
            this.enableLogCollection = enableLogCollection;
            this.changedFields = changedFields.add("enableLogCollection");
            return this;
        }

        public DeviceManagementSettings build() {
            DeviceManagementSettings _x = new DeviceManagementSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettings";
            _x.deviceComplianceCheckinThresholdDays = deviceComplianceCheckinThresholdDays;
            _x.isScheduledActionEnabled = isScheduledActionEnabled;
            _x.secureByDefault = secureByDefault;
            _x.enhancedJailBreak = enhancedJailBreak;
            _x.deviceInactivityBeforeRetirementInDay = deviceInactivityBeforeRetirementInDay;
            _x.derivedCredentialProvider = derivedCredentialProvider;
            _x.derivedCredentialUrl = derivedCredentialUrl;
            _x.androidDeviceAdministratorEnrollmentEnabled = androidDeviceAdministratorEnrollmentEnabled;
            _x.ignoreDevicesForUnsupportedSettingsEnabled = ignoreDevicesForUnsupportedSettingsEnabled;
            _x.enableLogCollection = enableLogCollection;
            return _x;
        }
    }

    private DeviceManagementSettings _copy() {
        DeviceManagementSettings _x = new DeviceManagementSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceComplianceCheckinThresholdDays = deviceComplianceCheckinThresholdDays;
        _x.isScheduledActionEnabled = isScheduledActionEnabled;
        _x.secureByDefault = secureByDefault;
        _x.enhancedJailBreak = enhancedJailBreak;
        _x.deviceInactivityBeforeRetirementInDay = deviceInactivityBeforeRetirementInDay;
        _x.derivedCredentialProvider = derivedCredentialProvider;
        _x.derivedCredentialUrl = derivedCredentialUrl;
        _x.androidDeviceAdministratorEnrollmentEnabled = androidDeviceAdministratorEnrollmentEnabled;
        _x.ignoreDevicesForUnsupportedSettingsEnabled = ignoreDevicesForUnsupportedSettingsEnabled;
        _x.enableLogCollection = enableLogCollection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettings[");
        b.append("deviceComplianceCheckinThresholdDays=");
        b.append(this.deviceComplianceCheckinThresholdDays);
        b.append(", ");
        b.append("isScheduledActionEnabled=");
        b.append(this.isScheduledActionEnabled);
        b.append(", ");
        b.append("secureByDefault=");
        b.append(this.secureByDefault);
        b.append(", ");
        b.append("enhancedJailBreak=");
        b.append(this.enhancedJailBreak);
        b.append(", ");
        b.append("deviceInactivityBeforeRetirementInDay=");
        b.append(this.deviceInactivityBeforeRetirementInDay);
        b.append(", ");
        b.append("derivedCredentialProvider=");
        b.append(this.derivedCredentialProvider);
        b.append(", ");
        b.append("derivedCredentialUrl=");
        b.append(this.derivedCredentialUrl);
        b.append(", ");
        b.append("androidDeviceAdministratorEnrollmentEnabled=");
        b.append(this.androidDeviceAdministratorEnrollmentEnabled);
        b.append(", ");
        b.append("ignoreDevicesForUnsupportedSettingsEnabled=");
        b.append(this.ignoreDevicesForUnsupportedSettingsEnabled);
        b.append(", ");
        b.append("enableLogCollection=");
        b.append(this.enableLogCollection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
