package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Constraint enforcing a given string length range”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "minimumLength", 
    "maximumLength"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingStringLengthConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("minimumLength")
    protected Integer minimumLength;

    @JsonProperty("maximumLength")
    protected Integer maximumLength;

    protected DeviceManagementSettingStringLengthConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingStringLengthConstraint";
    }

    /**
     * <i>“The minimum permitted string length”</i>
     * 
     * @return property minimumLength
     */
    @Property(name="minimumLength")
    @JsonIgnore
    public Optional<Integer> getMinimumLength() {
        return Optional.ofNullable(minimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The minimum permitted string length”</i>
     * 
     * @param minimumLength
     *            new value of {@code minimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumLength} field changed
     */
    public DeviceManagementSettingStringLengthConstraint withMinimumLength(Integer minimumLength) {
        DeviceManagementSettingStringLengthConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingStringLengthConstraint");
        _x.minimumLength = minimumLength;
        return _x;
    }

    /**
     * <i>“The maximum permitted string length”</i>
     * 
     * @return property maximumLength
     */
    @Property(name="maximumLength")
    @JsonIgnore
    public Optional<Integer> getMaximumLength() {
        return Optional.ofNullable(maximumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The maximum permitted string length”</i>
     * 
     * @param maximumLength
     *            new value of {@code maximumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumLength} field changed
     */
    public DeviceManagementSettingStringLengthConstraint withMaximumLength(Integer maximumLength) {
        DeviceManagementSettingStringLengthConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingStringLengthConstraint");
        _x.maximumLength = maximumLength;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingStringLengthConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private Integer minimumLength;
        private Integer maximumLength;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The minimum permitted string length”</i>
         * 
         * @param minimumLength
         *            value of {@code minimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            this.changedFields = changedFields.add("minimumLength");
            return this;
        }

        /**
         * <i>“The maximum permitted string length”</i>
         * 
         * @param maximumLength
         *            value of {@code maximumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            this.changedFields = changedFields.add("maximumLength");
            return this;
        }

        public DeviceManagementSettingStringLengthConstraint build() {
            DeviceManagementSettingStringLengthConstraint _x = new DeviceManagementSettingStringLengthConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingStringLengthConstraint";
            _x.minimumLength = minimumLength;
            _x.maximumLength = maximumLength;
            return _x;
        }
    }

    private DeviceManagementSettingStringLengthConstraint _copy() {
        DeviceManagementSettingStringLengthConstraint _x = new DeviceManagementSettingStringLengthConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.minimumLength = minimumLength;
        _x.maximumLength = maximumLength;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingStringLengthConstraint[");
        b.append("minimumLength=");
        b.append(this.minimumLength);
        b.append(", ");
        b.append("maximumLength=");
        b.append(this.maximumLength);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
