package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Constraint that enforces a particular required setting that is not null/
 * undefined/empty string/not configured”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "notConfiguredValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingRequiredConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("notConfiguredValue")
    protected String notConfiguredValue;

    protected DeviceManagementSettingRequiredConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingRequiredConstraint";
    }

    /**
     * <i>“List of value which means not configured for the setting”</i>
     * 
     * @return property notConfiguredValue
     */
    @Property(name="notConfiguredValue")
    @JsonIgnore
    public Optional<String> getNotConfiguredValue() {
        return Optional.ofNullable(notConfiguredValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notConfiguredValue} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of value which means not configured for the setting”</i>
     * 
     * @param notConfiguredValue
     *            new value of {@code notConfiguredValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notConfiguredValue} field changed
     */
    public DeviceManagementSettingRequiredConstraint withNotConfiguredValue(String notConfiguredValue) {
        DeviceManagementSettingRequiredConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingRequiredConstraint");
        _x.notConfiguredValue = notConfiguredValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingRequiredConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private String notConfiguredValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of value which means not configured for the setting”</i>
         * 
         * @param notConfiguredValue
         *            value of {@code notConfiguredValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notConfiguredValue(String notConfiguredValue) {
            this.notConfiguredValue = notConfiguredValue;
            this.changedFields = changedFields.add("notConfiguredValue");
            return this;
        }

        public DeviceManagementSettingRequiredConstraint build() {
            DeviceManagementSettingRequiredConstraint _x = new DeviceManagementSettingRequiredConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingRequiredConstraint";
            _x.notConfiguredValue = notConfiguredValue;
            return _x;
        }
    }

    private DeviceManagementSettingRequiredConstraint _copy() {
        DeviceManagementSettingRequiredConstraint _x = new DeviceManagementSettingRequiredConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.notConfiguredValue = notConfiguredValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingRequiredConstraint[");
        b.append("notConfiguredValue=");
        b.append(this.notConfiguredValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
