package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Constraint enforcing the permitted value range for an integer setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "minimumValue", 
    "maximumValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingIntegerConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("minimumValue")
    protected Integer minimumValue;

    @JsonProperty("maximumValue")
    protected Integer maximumValue;

    protected DeviceManagementSettingIntegerConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingIntegerConstraint";
    }

    /**
     * <i>“The minimum permitted value”</i>
     * 
     * @return property minimumValue
     */
    @Property(name="minimumValue")
    @JsonIgnore
    public Optional<Integer> getMinimumValue() {
        return Optional.ofNullable(minimumValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The minimum permitted value”</i>
     * 
     * @param minimumValue
     *            new value of {@code minimumValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumValue} field changed
     */
    public DeviceManagementSettingIntegerConstraint withMinimumValue(Integer minimumValue) {
        DeviceManagementSettingIntegerConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingIntegerConstraint");
        _x.minimumValue = minimumValue;
        return _x;
    }

    /**
     * <i>“The maximum permitted value”</i>
     * 
     * @return property maximumValue
     */
    @Property(name="maximumValue")
    @JsonIgnore
    public Optional<Integer> getMaximumValue() {
        return Optional.ofNullable(maximumValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The maximum permitted value”</i>
     * 
     * @param maximumValue
     *            new value of {@code maximumValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumValue} field changed
     */
    public DeviceManagementSettingIntegerConstraint withMaximumValue(Integer maximumValue) {
        DeviceManagementSettingIntegerConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingIntegerConstraint");
        _x.maximumValue = maximumValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingIntegerConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private Integer minimumValue;
        private Integer maximumValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The minimum permitted value”</i>
         * 
         * @param minimumValue
         *            value of {@code minimumValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumValue(Integer minimumValue) {
            this.minimumValue = minimumValue;
            this.changedFields = changedFields.add("minimumValue");
            return this;
        }

        /**
         * <i>“The maximum permitted value”</i>
         * 
         * @param maximumValue
         *            value of {@code maximumValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumValue(Integer maximumValue) {
            this.maximumValue = maximumValue;
            this.changedFields = changedFields.add("maximumValue");
            return this;
        }

        public DeviceManagementSettingIntegerConstraint build() {
            DeviceManagementSettingIntegerConstraint _x = new DeviceManagementSettingIntegerConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingIntegerConstraint";
            _x.minimumValue = minimumValue;
            _x.maximumValue = maximumValue;
            return _x;
        }
    }

    private DeviceManagementSettingIntegerConstraint _copy() {
        DeviceManagementSettingIntegerConstraint _x = new DeviceManagementSettingIntegerConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.minimumValue = minimumValue;
        _x.maximumValue = maximumValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingIntegerConstraint[");
        b.append("minimumValue=");
        b.append(this.minimumValue);
        b.append(", ");
        b.append("maximumValue=");
        b.append(this.maximumValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
