package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint enforcing the file extension is acceptable for a given setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "supportedExtensions"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingFileConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("supportedExtensions")
    protected List<String> supportedExtensions;

    @JsonProperty("supportedExtensions@nextLink")
    protected String supportedExtensionsNextLink;

    protected DeviceManagementSettingFileConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingFileConstraint";
    }

    /**
     * <i>“Acceptable file extensions to upload for this setting”</i>
     * 
     * @return property supportedExtensions
     */
    @Property(name="supportedExtensions")
    @JsonIgnore
    public CollectionPage<String> getSupportedExtensions() {
        return new CollectionPage<String>(contextPath, String.class, supportedExtensions, Optional.ofNullable(supportedExtensionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Acceptable file extensions to upload for this setting”</i>
     * 
     * @return property supportedExtensions
     */
    @Property(name="supportedExtensions")
    @JsonIgnore
    public CollectionPage<String> getSupportedExtensions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, supportedExtensions, Optional.ofNullable(supportedExtensionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingFileConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> supportedExtensions;
        private String supportedExtensionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Acceptable file extensions to upload for this setting”</i>
         * 
         * @param supportedExtensions
         *            value of {@code supportedExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedExtensions(List<String> supportedExtensions) {
            this.supportedExtensions = supportedExtensions;
            this.changedFields = changedFields.add("supportedExtensions");
            return this;
        }

        /**
         * <i>“Acceptable file extensions to upload for this setting”</i>
         * 
         * @param supportedExtensions
         *            value of {@code supportedExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedExtensions(String... supportedExtensions) {
            return supportedExtensions(Arrays.asList(supportedExtensions));
        }

        /**
         * <i>“Acceptable file extensions to upload for this setting”</i>
         * 
         * @param supportedExtensionsNextLink
         *            value of {@code supportedExtensions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedExtensionsNextLink(String supportedExtensionsNextLink) {
            this.supportedExtensionsNextLink = supportedExtensionsNextLink;
            this.changedFields = changedFields.add("supportedExtensions");
            return this;
        }

        public DeviceManagementSettingFileConstraint build() {
            DeviceManagementSettingFileConstraint _x = new DeviceManagementSettingFileConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingFileConstraint";
            _x.supportedExtensions = supportedExtensions;
            _x.supportedExtensionsNextLink = supportedExtensionsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingFileConstraint[");
        b.append("supportedExtensions=");
        b.append(this.supportedExtensions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
