package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Dependency information for a setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "definitionId", 
    "constraints"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingDependency implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("definitionId")
    protected String definitionId;

    @JsonProperty("constraints")
    protected List<DeviceManagementConstraint> constraints;

    @JsonProperty("constraints@nextLink")
    protected String constraintsNextLink;

    protected DeviceManagementSettingDependency() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingDependency";
    }

    /**
     * <i>“The setting definition ID of the setting depended on”</i>
     * 
     * @return property definitionId
     */
    @Property(name="definitionId")
    @JsonIgnore
    public Optional<String> getDefinitionId() {
        return Optional.ofNullable(definitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code definitionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting definition ID of the setting depended on”</i>
     * 
     * @param definitionId
     *            new value of {@code definitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code definitionId} field changed
     */
    public DeviceManagementSettingDependency withDefinitionId(String definitionId) {
        DeviceManagementSettingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDependency");
        _x.definitionId = definitionId;
        return _x;
    }

    /**
     * <i>“Collection of constraints for the dependency setting value”</i>
     * 
     * @return property constraints
     */
    @Property(name="constraints")
    @JsonIgnore
    public CollectionPage<DeviceManagementConstraint> getConstraints() {
        return new CollectionPage<DeviceManagementConstraint>(contextPath, DeviceManagementConstraint.class, constraints, Optional.ofNullable(constraintsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of constraints for the dependency setting value”</i>
     * 
     * @return property constraints
     */
    @Property(name="constraints")
    @JsonIgnore
    public CollectionPage<DeviceManagementConstraint> getConstraints(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConstraint>(contextPath, DeviceManagementConstraint.class, constraints, Optional.ofNullable(constraintsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String definitionId;
        private List<DeviceManagementConstraint> constraints;
        private String constraintsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The setting definition ID of the setting depended on”</i>
         * 
         * @param definitionId
         *            value of {@code definitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder definitionId(String definitionId) {
            this.definitionId = definitionId;
            this.changedFields = changedFields.add("definitionId");
            return this;
        }

        /**
         * <i>“Collection of constraints for the dependency setting value”</i>
         * 
         * @param constraints
         *            value of {@code constraints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraints(List<DeviceManagementConstraint> constraints) {
            this.constraints = constraints;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        /**
         * <i>“Collection of constraints for the dependency setting value”</i>
         * 
         * @param constraints
         *            value of {@code constraints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraints(DeviceManagementConstraint... constraints) {
            return constraints(Arrays.asList(constraints));
        }

        /**
         * <i>“Collection of constraints for the dependency setting value”</i>
         * 
         * @param constraintsNextLink
         *            value of {@code constraints@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraintsNextLink(String constraintsNextLink) {
            this.constraintsNextLink = constraintsNextLink;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        public DeviceManagementSettingDependency build() {
            DeviceManagementSettingDependency _x = new DeviceManagementSettingDependency();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingDependency";
            _x.definitionId = definitionId;
            _x.constraints = constraints;
            _x.constraintsNextLink = constraintsNextLink;
            return _x;
        }
    }

    private DeviceManagementSettingDependency _copy() {
        DeviceManagementSettingDependency _x = new DeviceManagementSettingDependency();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.definitionId = definitionId;
        _x.constraints = constraints;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingDependency[");
        b.append("definitionId=");
        b.append(this.definitionId);
        b.append(", ");
        b.append("constraints=");
        b.append(this.constraints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
