package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint enforcing the setting contains only vaild app types.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "supportedTypes"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingAppConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("supportedTypes")
    protected List<String> supportedTypes;

    @JsonProperty("supportedTypes@nextLink")
    protected String supportedTypesNextLink;

    protected DeviceManagementSettingAppConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingAppConstraint";
    }

    /**
     * <i>“Acceptable app types to allow for this setting”</i>
     * 
     * @return property supportedTypes
     */
    @Property(name="supportedTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedTypes() {
        return new CollectionPage<String>(contextPath, String.class, supportedTypes, Optional.ofNullable(supportedTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Acceptable app types to allow for this setting”</i>
     * 
     * @return property supportedTypes
     */
    @Property(name="supportedTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, supportedTypes, Optional.ofNullable(supportedTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingAppConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> supportedTypes;
        private String supportedTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Acceptable app types to allow for this setting”</i>
         * 
         * @param supportedTypes
         *            value of {@code supportedTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedTypes(List<String> supportedTypes) {
            this.supportedTypes = supportedTypes;
            this.changedFields = changedFields.add("supportedTypes");
            return this;
        }

        /**
         * <i>“Acceptable app types to allow for this setting”</i>
         * 
         * @param supportedTypes
         *            value of {@code supportedTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedTypes(String... supportedTypes) {
            return supportedTypes(Arrays.asList(supportedTypes));
        }

        /**
         * <i>“Acceptable app types to allow for this setting”</i>
         * 
         * @param supportedTypesNextLink
         *            value of {@code supportedTypes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedTypesNextLink(String supportedTypesNextLink) {
            this.supportedTypesNextLink = supportedTypesNextLink;
            this.changedFields = changedFields.add("supportedTypes");
            return this;
        }

        public DeviceManagementSettingAppConstraint build() {
            DeviceManagementSettingAppConstraint _x = new DeviceManagementSettingAppConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingAppConstraint";
            _x.supportedTypes = supportedTypes;
            _x.supportedTypesNextLink = supportedTypesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingAppConstraint[");
        b.append("supportedTypes=");
        b.append(this.supportedTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
