package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint that enforces an AbstractComplex type has or is set to a particular
 * value”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedAbstractImplementationDefinitionIds"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingAbstractImplementationConstraint extends DeviceManagementConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("allowedAbstractImplementationDefinitionIds")
    protected List<String> allowedAbstractImplementationDefinitionIds;

    @JsonProperty("allowedAbstractImplementationDefinitionIds@nextLink")
    protected String allowedAbstractImplementationDefinitionIdsNextLink;

    protected DeviceManagementSettingAbstractImplementationConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingAbstractImplementationConstraint";
    }

    /**
     * <i>“List of value which means not configured for the setting”</i>
     * 
     * @return property allowedAbstractImplementationDefinitionIds
     */
    @Property(name="allowedAbstractImplementationDefinitionIds")
    @JsonIgnore
    public CollectionPage<String> getAllowedAbstractImplementationDefinitionIds() {
        return new CollectionPage<String>(contextPath, String.class, allowedAbstractImplementationDefinitionIds, Optional.ofNullable(allowedAbstractImplementationDefinitionIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of value which means not configured for the setting”</i>
     * 
     * @return property allowedAbstractImplementationDefinitionIds
     */
    @Property(name="allowedAbstractImplementationDefinitionIds")
    @JsonIgnore
    public CollectionPage<String> getAllowedAbstractImplementationDefinitionIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, allowedAbstractImplementationDefinitionIds, Optional.ofNullable(allowedAbstractImplementationDefinitionIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingAbstractImplementationConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedAbstractImplementationDefinitionIds;
        private String allowedAbstractImplementationDefinitionIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of value which means not configured for the setting”</i>
         * 
         * @param allowedAbstractImplementationDefinitionIds
         *            value of {@code allowedAbstractImplementationDefinitionIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAbstractImplementationDefinitionIds(List<String> allowedAbstractImplementationDefinitionIds) {
            this.allowedAbstractImplementationDefinitionIds = allowedAbstractImplementationDefinitionIds;
            this.changedFields = changedFields.add("allowedAbstractImplementationDefinitionIds");
            return this;
        }

        /**
         * <i>“List of value which means not configured for the setting”</i>
         * 
         * @param allowedAbstractImplementationDefinitionIds
         *            value of {@code allowedAbstractImplementationDefinitionIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAbstractImplementationDefinitionIds(String... allowedAbstractImplementationDefinitionIds) {
            return allowedAbstractImplementationDefinitionIds(Arrays.asList(allowedAbstractImplementationDefinitionIds));
        }

        /**
         * <i>“List of value which means not configured for the setting”</i>
         * 
         * @param allowedAbstractImplementationDefinitionIdsNextLink
         *            value of {@code allowedAbstractImplementationDefinitionIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAbstractImplementationDefinitionIdsNextLink(String allowedAbstractImplementationDefinitionIdsNextLink) {
            this.allowedAbstractImplementationDefinitionIdsNextLink = allowedAbstractImplementationDefinitionIdsNextLink;
            this.changedFields = changedFields.add("allowedAbstractImplementationDefinitionIds");
            return this;
        }

        public DeviceManagementSettingAbstractImplementationConstraint build() {
            DeviceManagementSettingAbstractImplementationConstraint _x = new DeviceManagementSettingAbstractImplementationConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingAbstractImplementationConstraint";
            _x.allowedAbstractImplementationDefinitionIds = allowedAbstractImplementationDefinitionIds;
            _x.allowedAbstractImplementationDefinitionIdsNextLink = allowedAbstractImplementationDefinitionIdsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingAbstractImplementationConstraint[");
        b.append("allowedAbstractImplementationDefinitionIds=");
        b.append(this.allowedAbstractImplementationDefinitionIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
