package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessLevel;


/**
 * <i>“Device Access Rules in Exchange.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceClass", 
    "accessLevel"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementExchangeAccessRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceClass")
    protected DeviceManagementExchangeDeviceClass deviceClass;

    @JsonProperty("accessLevel")
    protected DeviceManagementExchangeAccessLevel accessLevel;

    protected DeviceManagementExchangeAccessRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementExchangeAccessRule";
    }

    /**
     * <i>“Device Class which will be impacted by this rule.”</i>
     * 
     * @return property deviceClass
     */
    @Property(name="deviceClass")
    @JsonIgnore
    public Optional<DeviceManagementExchangeDeviceClass> getDeviceClass() {
        return Optional.ofNullable(deviceClass);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceClass}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device Class which will be impacted by this rule.”</i>
     * 
     * @param deviceClass
     *            new value of {@code deviceClass} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceClass} field changed
     */
    public DeviceManagementExchangeAccessRule withDeviceClass(DeviceManagementExchangeDeviceClass deviceClass) {
        DeviceManagementExchangeAccessRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeAccessRule");
        _x.deviceClass = deviceClass;
        return _x;
    }

    /**
     * <i>“Access Level for Exchange granted by this rule.”</i>
     * 
     * @return property accessLevel
     */
    @Property(name="accessLevel")
    @JsonIgnore
    public Optional<DeviceManagementExchangeAccessLevel> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accessLevel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Access Level for Exchange granted by this rule.”</i>
     * 
     * @param accessLevel
     *            new value of {@code accessLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accessLevel} field changed
     */
    public DeviceManagementExchangeAccessRule withAccessLevel(DeviceManagementExchangeAccessLevel accessLevel) {
        DeviceManagementExchangeAccessRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeAccessRule");
        _x.accessLevel = accessLevel;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementExchangeDeviceClass deviceClass;
        private DeviceManagementExchangeAccessLevel accessLevel;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device Class which will be impacted by this rule.”</i>
         * 
         * @param deviceClass
         *            value of {@code deviceClass} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceClass(DeviceManagementExchangeDeviceClass deviceClass) {
            this.deviceClass = deviceClass;
            this.changedFields = changedFields.add("deviceClass");
            return this;
        }

        /**
         * <i>“Access Level for Exchange granted by this rule.”</i>
         * 
         * @param accessLevel
         *            value of {@code accessLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessLevel(DeviceManagementExchangeAccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            this.changedFields = changedFields.add("accessLevel");
            return this;
        }

        public DeviceManagementExchangeAccessRule build() {
            DeviceManagementExchangeAccessRule _x = new DeviceManagementExchangeAccessRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementExchangeAccessRule";
            _x.deviceClass = deviceClass;
            _x.accessLevel = accessLevel;
            return _x;
        }
    }

    private DeviceManagementExchangeAccessRule _copy() {
        DeviceManagementExchangeAccessRule _x = new DeviceManagementExchangeAccessRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceClass = deviceClass;
        _x.accessLevel = accessLevel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementExchangeAccessRule[");
        b.append("deviceClass=");
        b.append(this.deviceClass);
        b.append(", ");
        b.append("accessLevel=");
        b.append(this.accessLevel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
