package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementApplicabilityRuleType;
import odata.msgraph.client.beta.enums.Windows10EditionType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "osEditionTypes", 
    "name", 
    "ruleType"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementApplicabilityRuleOsEdition implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("osEditionTypes")
    protected List<Windows10EditionType> osEditionTypes;

    @JsonProperty("osEditionTypes@nextLink")
    protected String osEditionTypesNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("ruleType")
    protected DeviceManagementApplicabilityRuleType ruleType;

    protected DeviceManagementApplicabilityRuleOsEdition() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementApplicabilityRuleOsEdition";
    }

    /**
     * <i>“Applicability rule OS edition type.”</i>
     * 
     * @return property osEditionTypes
     */
    @Property(name="osEditionTypes")
    @JsonIgnore
    public CollectionPage<Windows10EditionType> getOsEditionTypes() {
        return new CollectionPage<Windows10EditionType>(contextPath, Windows10EditionType.class, osEditionTypes, Optional.ofNullable(osEditionTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Applicability rule OS edition type.”</i>
     * 
     * @return property osEditionTypes
     */
    @Property(name="osEditionTypes")
    @JsonIgnore
    public CollectionPage<Windows10EditionType> getOsEditionTypes(HttpRequestOptions options) {
        return new CollectionPage<Windows10EditionType>(contextPath, Windows10EditionType.class, osEditionTypes, Optional.ofNullable(osEditionTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Name for object.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name for object.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementApplicabilityRuleOsEdition withName(String name) {
        DeviceManagementApplicabilityRuleOsEdition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsEdition");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Applicability Rule type.”</i>
     * 
     * @return property ruleType
     */
    @Property(name="ruleType")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleType> getRuleType() {
        return Optional.ofNullable(ruleType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ruleType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Applicability Rule type.”</i>
     * 
     * @param ruleType
     *            new value of {@code ruleType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ruleType} field changed
     */
    public DeviceManagementApplicabilityRuleOsEdition withRuleType(DeviceManagementApplicabilityRuleType ruleType) {
        DeviceManagementApplicabilityRuleOsEdition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleOsEdition");
        _x.ruleType = ruleType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Windows10EditionType> osEditionTypes;
        private String osEditionTypesNextLink;
        private String name;
        private DeviceManagementApplicabilityRuleType ruleType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Applicability rule OS edition type.”</i>
         * 
         * @param osEditionTypes
         *            value of {@code osEditionTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osEditionTypes(List<Windows10EditionType> osEditionTypes) {
            this.osEditionTypes = osEditionTypes;
            this.changedFields = changedFields.add("osEditionTypes");
            return this;
        }

        /**
         * <i>“Applicability rule OS edition type.”</i>
         * 
         * @param osEditionTypes
         *            value of {@code osEditionTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osEditionTypes(Windows10EditionType... osEditionTypes) {
            return osEditionTypes(Arrays.asList(osEditionTypes));
        }

        /**
         * <i>“Applicability rule OS edition type.”</i>
         * 
         * @param osEditionTypesNextLink
         *            value of {@code osEditionTypes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osEditionTypesNextLink(String osEditionTypesNextLink) {
            this.osEditionTypesNextLink = osEditionTypesNextLink;
            this.changedFields = changedFields.add("osEditionTypes");
            return this;
        }

        /**
         * <i>“Name for object.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Applicability Rule type.”</i>
         * 
         * @param ruleType
         *            value of {@code ruleType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleType(DeviceManagementApplicabilityRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        public DeviceManagementApplicabilityRuleOsEdition build() {
            DeviceManagementApplicabilityRuleOsEdition _x = new DeviceManagementApplicabilityRuleOsEdition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementApplicabilityRuleOsEdition";
            _x.osEditionTypes = osEditionTypes;
            _x.osEditionTypesNextLink = osEditionTypesNextLink;
            _x.name = name;
            _x.ruleType = ruleType;
            return _x;
        }
    }

    private DeviceManagementApplicabilityRuleOsEdition _copy() {
        DeviceManagementApplicabilityRuleOsEdition _x = new DeviceManagementApplicabilityRuleOsEdition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.osEditionTypes = osEditionTypes;
        _x.name = name;
        _x.ruleType = ruleType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementApplicabilityRuleOsEdition[");
        b.append("osEditionTypes=");
        b.append(this.osEditionTypes);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
