package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementApplicabilityRuleType;
import odata.msgraph.client.beta.enums.Windows10DeviceModeType;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceMode", 
    "name", 
    "ruleType"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementApplicabilityRuleDeviceMode implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceMode")
    protected Windows10DeviceModeType deviceMode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("ruleType")
    protected DeviceManagementApplicabilityRuleType ruleType;

    protected DeviceManagementApplicabilityRuleDeviceMode() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementApplicabilityRuleDeviceMode";
    }

    /**
     * <i>“Applicability rule for device mode.”</i>
     * 
     * @return property deviceMode
     */
    @Property(name="deviceMode")
    @JsonIgnore
    public Optional<Windows10DeviceModeType> getDeviceMode() {
        return Optional.ofNullable(deviceMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceMode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Applicability rule for device mode.”</i>
     * 
     * @param deviceMode
     *            new value of {@code deviceMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceMode} field changed
     */
    public DeviceManagementApplicabilityRuleDeviceMode withDeviceMode(Windows10DeviceModeType deviceMode) {
        DeviceManagementApplicabilityRuleDeviceMode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleDeviceMode");
        _x.deviceMode = deviceMode;
        return _x;
    }

    /**
     * <i>“Name for object.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name for object.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementApplicabilityRuleDeviceMode withName(String name) {
        DeviceManagementApplicabilityRuleDeviceMode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleDeviceMode");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Applicability Rule type.”</i>
     * 
     * @return property ruleType
     */
    @Property(name="ruleType")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleType> getRuleType() {
        return Optional.ofNullable(ruleType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ruleType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Applicability Rule type.”</i>
     * 
     * @param ruleType
     *            new value of {@code ruleType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ruleType} field changed
     */
    public DeviceManagementApplicabilityRuleDeviceMode withRuleType(DeviceManagementApplicabilityRuleType ruleType) {
        DeviceManagementApplicabilityRuleDeviceMode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementApplicabilityRuleDeviceMode");
        _x.ruleType = ruleType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Windows10DeviceModeType deviceMode;
        private String name;
        private DeviceManagementApplicabilityRuleType ruleType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Applicability rule for device mode.”</i>
         * 
         * @param deviceMode
         *            value of {@code deviceMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceMode(Windows10DeviceModeType deviceMode) {
            this.deviceMode = deviceMode;
            this.changedFields = changedFields.add("deviceMode");
            return this;
        }

        /**
         * <i>“Name for object.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Applicability Rule type.”</i>
         * 
         * @param ruleType
         *            value of {@code ruleType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleType(DeviceManagementApplicabilityRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        public DeviceManagementApplicabilityRuleDeviceMode build() {
            DeviceManagementApplicabilityRuleDeviceMode _x = new DeviceManagementApplicabilityRuleDeviceMode();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementApplicabilityRuleDeviceMode";
            _x.deviceMode = deviceMode;
            _x.name = name;
            _x.ruleType = ruleType;
            return _x;
        }
    }

    private DeviceManagementApplicabilityRuleDeviceMode _copy() {
        DeviceManagementApplicabilityRuleDeviceMode _x = new DeviceManagementApplicabilityRuleDeviceMode();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceMode = deviceMode;
        _x.name = name;
        _x.ruleType = ruleType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementApplicabilityRuleDeviceMode[");
        b.append("deviceMode=");
        b.append(this.deviceMode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
