package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.util.Optional;


/**
 * <i>“Base type of Device health script time schedule.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "useUtc", 
    "time"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptTimeSchedule extends DeviceHealthScriptRunSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("useUtc")
    protected Boolean useUtc;

    @JsonProperty("time")
    protected LocalTime time;

    protected DeviceHealthScriptTimeSchedule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptTimeSchedule";
    }

    /**
     * <i>“Indicate if the time is Utc or client local time.”</i>
     * 
     * @return property useUtc
     */
    @Property(name="useUtc")
    @JsonIgnore
    public Optional<Boolean> getUseUtc() {
        return Optional.ofNullable(useUtc);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code useUtc} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicate if the time is Utc or client local time.”</i>
     * 
     * @param useUtc
     *            new value of {@code useUtc} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useUtc} field changed
     */
    public DeviceHealthScriptTimeSchedule withUseUtc(Boolean useUtc) {
        DeviceHealthScriptTimeSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptTimeSchedule");
        _x.useUtc = useUtc;
        return _x;
    }

    /**
     * <i>“At what time the script is scheduled to run. This collection can contain a
     * maximum of 20 elements.”</i>
     * 
     * @return property time
     */
    @Property(name="time")
    @JsonIgnore
    public Optional<LocalTime> getTime() {
        return Optional.ofNullable(time);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code time} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“At what time the script is scheduled to run. This collection can contain a
     * maximum of 20 elements.”</i>
     * 
     * @param time
     *            new value of {@code time} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code time} field changed
     */
    public DeviceHealthScriptTimeSchedule withTime(LocalTime time) {
        DeviceHealthScriptTimeSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptTimeSchedule");
        _x.time = time;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceHealthScriptTimeSchedule _copy() {
        DeviceHealthScriptTimeSchedule _x = new DeviceHealthScriptTimeSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.interval = interval;
        _x.useUtc = useUtc;
        _x.time = time;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptTimeSchedule[");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("useUtc=");
        b.append(this.useUtc);
        b.append(", ");
        b.append("time=");
        b.append(this.time);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
