package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;


/**
 * <i>“The number of devices remediated by a device health script on a given date.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "date", 
    "remediatedDeviceCount", 
    "noIssueDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRemediationHistoryData implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("date")
    protected LocalDate date;

    @JsonProperty("remediatedDeviceCount")
    protected Integer remediatedDeviceCount;

    @JsonProperty("noIssueDeviceCount")
    protected Integer noIssueDeviceCount;

    protected DeviceHealthScriptRemediationHistoryData() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRemediationHistoryData";
    }

    /**
     * <i>“The date on which devices were remediated by the device health script.”</i>
     * 
     * @return property date
     */
    @Property(name="date")
    @JsonIgnore
    public Optional<LocalDate> getDate() {
        return Optional.ofNullable(date);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code date} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The date on which devices were remediated by the device health script.”</i>
     * 
     * @param date
     *            new value of {@code date} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code date} field changed
     */
    public DeviceHealthScriptRemediationHistoryData withDate(LocalDate date) {
        DeviceHealthScriptRemediationHistoryData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationHistoryData");
        _x.date = date;
        return _x;
    }

    /**
     * <i>“The number of devices remediated by the device health script.”</i>
     * 
     * @return property remediatedDeviceCount
     */
    @Property(name="remediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedDeviceCount() {
        return Optional.ofNullable(remediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices remediated by the device health script.”</i>
     * 
     * @param remediatedDeviceCount
     *            new value of {@code remediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedDeviceCount} field changed
     */
    public DeviceHealthScriptRemediationHistoryData withRemediatedDeviceCount(Integer remediatedDeviceCount) {
        DeviceHealthScriptRemediationHistoryData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationHistoryData");
        _x.remediatedDeviceCount = remediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices that were found to have no issue by the device health
     * script.”</i>
     * 
     * @return property noIssueDeviceCount
     */
    @Property(name="noIssueDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNoIssueDeviceCount() {
        return Optional.ofNullable(noIssueDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * noIssueDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices that were found to have no issue by the device health
     * script.”</i>
     * 
     * @param noIssueDeviceCount
     *            new value of {@code noIssueDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code noIssueDeviceCount} field changed
     */
    public DeviceHealthScriptRemediationHistoryData withNoIssueDeviceCount(Integer noIssueDeviceCount) {
        DeviceHealthScriptRemediationHistoryData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRemediationHistoryData");
        _x.noIssueDeviceCount = noIssueDeviceCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LocalDate date;
        private Integer remediatedDeviceCount;
        private Integer noIssueDeviceCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The date on which devices were remediated by the device health script.”</i>
         * 
         * @param date
         *            value of {@code date} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder date(LocalDate date) {
            this.date = date;
            this.changedFields = changedFields.add("date");
            return this;
        }

        /**
         * <i>“The number of devices remediated by the device health script.”</i>
         * 
         * @param remediatedDeviceCount
         *            value of {@code remediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedDeviceCount(Integer remediatedDeviceCount) {
            this.remediatedDeviceCount = remediatedDeviceCount;
            this.changedFields = changedFields.add("remediatedDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices that were found to have no issue by the device health
         * script.”</i>
         * 
         * @param noIssueDeviceCount
         *            value of {@code noIssueDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder noIssueDeviceCount(Integer noIssueDeviceCount) {
            this.noIssueDeviceCount = noIssueDeviceCount;
            this.changedFields = changedFields.add("noIssueDeviceCount");
            return this;
        }

        public DeviceHealthScriptRemediationHistoryData build() {
            DeviceHealthScriptRemediationHistoryData _x = new DeviceHealthScriptRemediationHistoryData();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceHealthScriptRemediationHistoryData";
            _x.date = date;
            _x.remediatedDeviceCount = remediatedDeviceCount;
            _x.noIssueDeviceCount = noIssueDeviceCount;
            return _x;
        }
    }

    private DeviceHealthScriptRemediationHistoryData _copy() {
        DeviceHealthScriptRemediationHistoryData _x = new DeviceHealthScriptRemediationHistoryData();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.date = date;
        _x.remediatedDeviceCount = remediatedDeviceCount;
        _x.noIssueDeviceCount = noIssueDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRemediationHistoryData[");
        b.append("date=");
        b.append(this.date);
        b.append(", ");
        b.append("remediatedDeviceCount=");
        b.append(this.remediatedDeviceCount);
        b.append(", ");
        b.append("noIssueDeviceCount=");
        b.append(this.noIssueDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
