package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Base properties of the script parameter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "description", 
    "isRequired", 
    "applyDefaultValueWhenNotAssigned"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptParameter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("applyDefaultValueWhenNotAssigned")
    protected Boolean applyDefaultValueWhenNotAssigned;

    protected DeviceHealthScriptParameter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptParameter";
    }

    /**
     * <i>“The name of the param”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the param”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceHealthScriptParameter withName(String name) {
        DeviceHealthScriptParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptParameter");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The description of the param”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the param”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceHealthScriptParameter withDescription(String description) {
        DeviceHealthScriptParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptParameter");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Whether the param is required”</i>
     * 
     * @return property isRequired
     */
    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isRequired} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether the param is required”</i>
     * 
     * @param isRequired
     *            new value of {@code isRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isRequired} field changed
     */
    public DeviceHealthScriptParameter withIsRequired(Boolean isRequired) {
        DeviceHealthScriptParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptParameter");
        _x.isRequired = isRequired;
        return _x;
    }

    /**
     * <i>“Whether Apply DefaultValue When Not Assigned”</i>
     * 
     * @return property applyDefaultValueWhenNotAssigned
     */
    @Property(name="applyDefaultValueWhenNotAssigned")
    @JsonIgnore
    public Optional<Boolean> getApplyDefaultValueWhenNotAssigned() {
        return Optional.ofNullable(applyDefaultValueWhenNotAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applyDefaultValueWhenNotAssigned} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether Apply DefaultValue When Not Assigned”</i>
     * 
     * @param applyDefaultValueWhenNotAssigned
     *            new value of {@code applyDefaultValueWhenNotAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applyDefaultValueWhenNotAssigned} field changed
     */
    public DeviceHealthScriptParameter withApplyDefaultValueWhenNotAssigned(Boolean applyDefaultValueWhenNotAssigned) {
        DeviceHealthScriptParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptParameter");
        _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceHealthScriptParameter _copy() {
        DeviceHealthScriptParameter _x = new DeviceHealthScriptParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.description = description;
        _x.isRequired = isRequired;
        _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptParameter[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("applyDefaultValueWhenNotAssigned=");
        b.append(this.applyDefaultValueWhenNotAssigned);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
