package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;


/**
 * <i>“Device health script daily schedule.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptDailySchedule extends DeviceHealthScriptTimeSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    protected DeviceHealthScriptDailySchedule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptDailySchedule";
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptDailySchedule() {
        return new Builder();
    }

    public static final class Builder {
        private Integer interval;
        private Boolean useUtc;
        private LocalTime time;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public Builder useUtc(Boolean useUtc) {
            this.useUtc = useUtc;
            this.changedFields = changedFields.add("useUtc");
            return this;
        }

        public Builder time(LocalTime time) {
            this.time = time;
            this.changedFields = changedFields.add("time");
            return this;
        }

        public DeviceHealthScriptDailySchedule build() {
            DeviceHealthScriptDailySchedule _x = new DeviceHealthScriptDailySchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceHealthScriptDailySchedule";
            _x.interval = interval;
            _x.useUtc = useUtc;
            _x.time = time;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptDailySchedule[");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("useUtc=");
        b.append(this.useUtc);
        b.append(", ");
        b.append("time=");
        b.append(this.time);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
