package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Properties of the  Booolean script parameter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptBooleanParameter extends DeviceHealthScriptParameter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("defaultValue")
    protected Boolean defaultValue;

    protected DeviceHealthScriptBooleanParameter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptBooleanParameter";
    }

    /**
     * <i>“The default value of boolean param”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<Boolean> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The default value of boolean param”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public DeviceHealthScriptBooleanParameter withDefaultValue(Boolean defaultValue) {
        DeviceHealthScriptBooleanParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptBooleanParameter");
        _x.defaultValue = defaultValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptBooleanParameter() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private Boolean isRequired;
        private Boolean applyDefaultValueWhenNotAssigned;
        private Boolean defaultValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder applyDefaultValueWhenNotAssigned(Boolean applyDefaultValueWhenNotAssigned) {
            this.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
            this.changedFields = changedFields.add("applyDefaultValueWhenNotAssigned");
            return this;
        }

        /**
         * <i>“The default value of boolean param”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public DeviceHealthScriptBooleanParameter build() {
            DeviceHealthScriptBooleanParameter _x = new DeviceHealthScriptBooleanParameter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceHealthScriptBooleanParameter";
            _x.name = name;
            _x.description = description;
            _x.isRequired = isRequired;
            _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
            _x.defaultValue = defaultValue;
            return _x;
        }
    }

    private DeviceHealthScriptBooleanParameter _copy() {
        DeviceHealthScriptBooleanParameter _x = new DeviceHealthScriptBooleanParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.description = description;
        _x.isRequired = isRequired;
        _x.applyDefaultValueWhenNotAssigned = applyDefaultValueWhenNotAssigned;
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptBooleanParameter[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("applyDefaultValueWhenNotAssigned=");
        b.append(this.applyDefaultValueWhenNotAssigned);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
