package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Platform specific enrollment restrictions”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "platformBlocked", 
    "personalDeviceEnrollmentBlocked", 
    "osMinimumVersion", 
    "osMaximumVersion", 
    "blockedManufacturers"})
@JsonInclude(Include.NON_NULL)
public class DeviceEnrollmentPlatformRestriction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("platformBlocked")
    protected Boolean platformBlocked;

    @JsonProperty("personalDeviceEnrollmentBlocked")
    protected Boolean personalDeviceEnrollmentBlocked;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("blockedManufacturers")
    protected List<String> blockedManufacturers;

    @JsonProperty("blockedManufacturers@nextLink")
    protected String blockedManufacturersNextLink;

    protected DeviceEnrollmentPlatformRestriction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceEnrollmentPlatformRestriction";
    }

    /**
     * <i>“Block the platform from enrolling”</i>
     * 
     * @return property platformBlocked
     */
    @Property(name="platformBlocked")
    @JsonIgnore
    public Optional<Boolean> getPlatformBlocked() {
        return Optional.ofNullable(platformBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Block the platform from enrolling”</i>
     * 
     * @param platformBlocked
     *            new value of {@code platformBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformBlocked} field changed
     */
    public DeviceEnrollmentPlatformRestriction withPlatformBlocked(Boolean platformBlocked) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.platformBlocked = platformBlocked;
        return _x;
    }

    /**
     * <i>“Block personally owned devices from enrolling”</i>
     * 
     * @return property personalDeviceEnrollmentBlocked
     */
    @Property(name="personalDeviceEnrollmentBlocked")
    @JsonIgnore
    public Optional<Boolean> getPersonalDeviceEnrollmentBlocked() {
        return Optional.ofNullable(personalDeviceEnrollmentBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * personalDeviceEnrollmentBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Block personally owned devices from enrolling”</i>
     * 
     * @param personalDeviceEnrollmentBlocked
     *            new value of {@code personalDeviceEnrollmentBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code personalDeviceEnrollmentBlocked} field changed
     */
    public DeviceEnrollmentPlatformRestriction withPersonalDeviceEnrollmentBlocked(Boolean personalDeviceEnrollmentBlocked) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
        return _x;
    }

    /**
     * <i>“Min OS version supported”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Min OS version supported”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public DeviceEnrollmentPlatformRestriction withOsMinimumVersion(String osMinimumVersion) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Max OS version supported”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Max OS version supported”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public DeviceEnrollmentPlatformRestriction withOsMaximumVersion(String osMaximumVersion) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Collection of blocked Manufacturers.”</i>
     * 
     * @return property blockedManufacturers
     */
    @Property(name="blockedManufacturers")
    @JsonIgnore
    public CollectionPage<String> getBlockedManufacturers() {
        return new CollectionPage<String>(contextPath, String.class, blockedManufacturers, Optional.ofNullable(blockedManufacturersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of blocked Manufacturers.”</i>
     * 
     * @return property blockedManufacturers
     */
    @Property(name="blockedManufacturers")
    @JsonIgnore
    public CollectionPage<String> getBlockedManufacturers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, blockedManufacturers, Optional.ofNullable(blockedManufacturersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean platformBlocked;
        private Boolean personalDeviceEnrollmentBlocked;
        private String osMinimumVersion;
        private String osMaximumVersion;
        private List<String> blockedManufacturers;
        private String blockedManufacturersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Block the platform from enrolling”</i>
         * 
         * @param platformBlocked
         *            value of {@code platformBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformBlocked(Boolean platformBlocked) {
            this.platformBlocked = platformBlocked;
            this.changedFields = changedFields.add("platformBlocked");
            return this;
        }

        /**
         * <i>“Block personally owned devices from enrolling”</i>
         * 
         * @param personalDeviceEnrollmentBlocked
         *            value of {@code personalDeviceEnrollmentBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder personalDeviceEnrollmentBlocked(Boolean personalDeviceEnrollmentBlocked) {
            this.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
            this.changedFields = changedFields.add("personalDeviceEnrollmentBlocked");
            return this;
        }

        /**
         * <i>“Min OS version supported”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Max OS version supported”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturers
         *            value of {@code blockedManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturers(List<String> blockedManufacturers) {
            this.blockedManufacturers = blockedManufacturers;
            this.changedFields = changedFields.add("blockedManufacturers");
            return this;
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturers
         *            value of {@code blockedManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturers(String... blockedManufacturers) {
            return blockedManufacturers(Arrays.asList(blockedManufacturers));
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturersNextLink
         *            value of {@code blockedManufacturers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturersNextLink(String blockedManufacturersNextLink) {
            this.blockedManufacturersNextLink = blockedManufacturersNextLink;
            this.changedFields = changedFields.add("blockedManufacturers");
            return this;
        }

        public DeviceEnrollmentPlatformRestriction build() {
            DeviceEnrollmentPlatformRestriction _x = new DeviceEnrollmentPlatformRestriction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceEnrollmentPlatformRestriction";
            _x.platformBlocked = platformBlocked;
            _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
            _x.osMinimumVersion = osMinimumVersion;
            _x.osMaximumVersion = osMaximumVersion;
            _x.blockedManufacturers = blockedManufacturers;
            _x.blockedManufacturersNextLink = blockedManufacturersNextLink;
            return _x;
        }
    }

    private DeviceEnrollmentPlatformRestriction _copy() {
        DeviceEnrollmentPlatformRestriction _x = new DeviceEnrollmentPlatformRestriction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.platformBlocked = platformBlocked;
        _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
        _x.osMinimumVersion = osMinimumVersion;
        _x.osMaximumVersion = osMaximumVersion;
        _x.blockedManufacturers = blockedManufacturers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceEnrollmentPlatformRestriction[");
        b.append("platformBlocked=");
        b.append(this.platformBlocked);
        b.append(", ");
        b.append("personalDeviceEnrollmentBlocked=");
        b.append(this.personalDeviceEnrollmentBlocked);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("blockedManufacturers=");
        b.append(this.blockedManufacturers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
