package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ComplianceStatus;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Device Compilance Policy Setting State for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "setting", 
    "settingName", 
    "instanceDisplayName", 
    "state", 
    "errorCode", 
    "errorDescription", 
    "userId", 
    "userName", 
    "userEmail", 
    "userPrincipalName", 
    "sources", 
    "currentValue", 
    "settingInstanceId"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicySettingState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("setting")
    protected String setting;

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("instanceDisplayName")
    protected String instanceDisplayName;

    @JsonProperty("state")
    protected ComplianceStatus state;

    @JsonProperty("errorCode")
    protected Long errorCode;

    @JsonProperty("errorDescription")
    protected String errorDescription;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userEmail")
    protected String userEmail;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("sources")
    protected List<SettingSource> sources;

    @JsonProperty("sources@nextLink")
    protected String sourcesNextLink;

    @JsonProperty("currentValue")
    protected String currentValue;

    @JsonProperty("settingInstanceId")
    protected String settingInstanceId;

    protected DeviceCompliancePolicySettingState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicySettingState";
    }

    /**
     * <i>“The setting that is being reported”</i>
     * 
     * @return property setting
     */
    @Property(name="setting")
    @JsonIgnore
    public Optional<String> getSetting() {
        return Optional.ofNullable(setting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setting} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The setting that is being reported”</i>
     * 
     * @param setting
     *            new value of {@code setting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setting} field changed
     */
    public DeviceCompliancePolicySettingState withSetting(String setting) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.setting = setting;
        return _x;
    }

    /**
     * <i>“Localized/user friendly setting name that is being reported”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Localized/user friendly setting name that is being reported”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public DeviceCompliancePolicySettingState withSettingName(String settingName) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.settingName = settingName;
        return _x;
    }

    /**
     * <i>“Name of setting instance that is being reported.”</i>
     * 
     * @return property instanceDisplayName
     */
    @Property(name="instanceDisplayName")
    @JsonIgnore
    public Optional<String> getInstanceDisplayName() {
        return Optional.ofNullable(instanceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * instanceDisplayName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Name of setting instance that is being reported.”</i>
     * 
     * @param instanceDisplayName
     *            new value of {@code instanceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code instanceDisplayName} field changed
     */
    public DeviceCompliancePolicySettingState withInstanceDisplayName(String instanceDisplayName) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.instanceDisplayName = instanceDisplayName;
        return _x;
    }

    /**
     * <i>“The compliance state of the setting”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<ComplianceStatus> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The compliance state of the setting”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceCompliancePolicySettingState withState(ComplianceStatus state) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Error code for the setting”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Long> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code for the setting”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public DeviceCompliancePolicySettingState withErrorCode(Long errorCode) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Error description”</i>
     * 
     * @return property errorDescription
     */
    @Property(name="errorDescription")
    @JsonIgnore
    public Optional<String> getErrorDescription() {
        return Optional.ofNullable(errorDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error description”</i>
     * 
     * @param errorDescription
     *            new value of {@code errorDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDescription} field changed
     */
    public DeviceCompliancePolicySettingState withErrorDescription(String errorDescription) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.errorDescription = errorDescription;
        return _x;
    }

    /**
     * <i>“UserId”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserId”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public DeviceCompliancePolicySettingState withUserId(String userId) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“UserName”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserName”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public DeviceCompliancePolicySettingState withUserName(String userName) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“UserEmail”</i>
     * 
     * @return property userEmail
     */
    @Property(name="userEmail")
    @JsonIgnore
    public Optional<String> getUserEmail() {
        return Optional.ofNullable(userEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userEmail} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserEmail”</i>
     * 
     * @param userEmail
     *            new value of {@code userEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userEmail} field changed
     */
    public DeviceCompliancePolicySettingState withUserEmail(String userEmail) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.userEmail = userEmail;
        return _x;
    }

    /**
     * <i>“UserPrincipalName.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“UserPrincipalName.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceCompliancePolicySettingState withUserPrincipalName(String userPrincipalName) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Contributing policies”</i>
     * 
     * @return property sources
     */
    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<SettingSource> getSources() {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, sources, Optional.ofNullable(sourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Contributing policies”</i>
     * 
     * @return property sources
     */
    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<SettingSource> getSources(HttpRequestOptions options) {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, sources, Optional.ofNullable(sourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Current value of setting on device”</i>
     * 
     * @return property currentValue
     */
    @Property(name="currentValue")
    @JsonIgnore
    public Optional<String> getCurrentValue() {
        return Optional.ofNullable(currentValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code currentValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Current value of setting on device”</i>
     * 
     * @param currentValue
     *            new value of {@code currentValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code currentValue} field changed
     */
    public DeviceCompliancePolicySettingState withCurrentValue(String currentValue) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.currentValue = currentValue;
        return _x;
    }

    /**
     * <i>“SettingInstanceId”</i>
     * 
     * @return property settingInstanceId
     */
    @Property(name="settingInstanceId")
    @JsonIgnore
    public Optional<String> getSettingInstanceId() {
        return Optional.ofNullable(settingInstanceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingInstanceId
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SettingInstanceId”</i>
     * 
     * @param settingInstanceId
     *            new value of {@code settingInstanceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstanceId} field changed
     */
    public DeviceCompliancePolicySettingState withSettingInstanceId(String settingInstanceId) {
        DeviceCompliancePolicySettingState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicySettingState");
        _x.settingInstanceId = settingInstanceId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String setting;
        private String settingName;
        private String instanceDisplayName;
        private ComplianceStatus state;
        private Long errorCode;
        private String errorDescription;
        private String userId;
        private String userName;
        private String userEmail;
        private String userPrincipalName;
        private List<SettingSource> sources;
        private String sourcesNextLink;
        private String currentValue;
        private String settingInstanceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The setting that is being reported”</i>
         * 
         * @param setting
         *            value of {@code setting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setting(String setting) {
            this.setting = setting;
            this.changedFields = changedFields.add("setting");
            return this;
        }

        /**
         * <i>“Localized/user friendly setting name that is being reported”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        /**
         * <i>“Name of setting instance that is being reported.”</i>
         * 
         * @param instanceDisplayName
         *            value of {@code instanceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder instanceDisplayName(String instanceDisplayName) {
            this.instanceDisplayName = instanceDisplayName;
            this.changedFields = changedFields.add("instanceDisplayName");
            return this;
        }

        /**
         * <i>“The compliance state of the setting”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(ComplianceStatus state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Error code for the setting”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Long errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“Error description”</i>
         * 
         * @param errorDescription
         *            value of {@code errorDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            this.changedFields = changedFields.add("errorDescription");
            return this;
        }

        /**
         * <i>“UserId”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“UserName”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“UserEmail”</i>
         * 
         * @param userEmail
         *            value of {@code userEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            this.changedFields = changedFields.add("userEmail");
            return this;
        }

        /**
         * <i>“UserPrincipalName.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Contributing policies”</i>
         * 
         * @param sources
         *            value of {@code sources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sources(List<SettingSource> sources) {
            this.sources = sources;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        /**
         * <i>“Contributing policies”</i>
         * 
         * @param sources
         *            value of {@code sources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sources(SettingSource... sources) {
            return sources(Arrays.asList(sources));
        }

        /**
         * <i>“Contributing policies”</i>
         * 
         * @param sourcesNextLink
         *            value of {@code sources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourcesNextLink(String sourcesNextLink) {
            this.sourcesNextLink = sourcesNextLink;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        /**
         * <i>“Current value of setting on device”</i>
         * 
         * @param currentValue
         *            value of {@code currentValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder currentValue(String currentValue) {
            this.currentValue = currentValue;
            this.changedFields = changedFields.add("currentValue");
            return this;
        }

        /**
         * <i>“SettingInstanceId”</i>
         * 
         * @param settingInstanceId
         *            value of {@code settingInstanceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingInstanceId(String settingInstanceId) {
            this.settingInstanceId = settingInstanceId;
            this.changedFields = changedFields.add("settingInstanceId");
            return this;
        }

        public DeviceCompliancePolicySettingState build() {
            DeviceCompliancePolicySettingState _x = new DeviceCompliancePolicySettingState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceCompliancePolicySettingState";
            _x.setting = setting;
            _x.settingName = settingName;
            _x.instanceDisplayName = instanceDisplayName;
            _x.state = state;
            _x.errorCode = errorCode;
            _x.errorDescription = errorDescription;
            _x.userId = userId;
            _x.userName = userName;
            _x.userEmail = userEmail;
            _x.userPrincipalName = userPrincipalName;
            _x.sources = sources;
            _x.sourcesNextLink = sourcesNextLink;
            _x.currentValue = currentValue;
            _x.settingInstanceId = settingInstanceId;
            return _x;
        }
    }

    private DeviceCompliancePolicySettingState _copy() {
        DeviceCompliancePolicySettingState _x = new DeviceCompliancePolicySettingState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.setting = setting;
        _x.settingName = settingName;
        _x.instanceDisplayName = instanceDisplayName;
        _x.state = state;
        _x.errorCode = errorCode;
        _x.errorDescription = errorDescription;
        _x.userId = userId;
        _x.userName = userName;
        _x.userEmail = userEmail;
        _x.userPrincipalName = userPrincipalName;
        _x.sources = sources;
        _x.currentValue = currentValue;
        _x.settingInstanceId = settingInstanceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicySettingState[");
        b.append("setting=");
        b.append(this.setting);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("instanceDisplayName=");
        b.append(this.instanceDisplayName);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("errorDescription=");
        b.append(this.errorDescription);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userEmail=");
        b.append(this.userEmail);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("sources=");
        b.append(this.sources);
        b.append(", ");
        b.append("currentValue=");
        b.append(this.currentValue);
        b.append(", ");
        b.append("settingInstanceId=");
        b.append(this.settingInstanceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
