package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceComplianceScriptId", 
    "rulesContent"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicyScript implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceComplianceScriptId")
    protected String deviceComplianceScriptId;

    @JsonProperty("rulesContent")
    protected byte[] rulesContent;

    protected DeviceCompliancePolicyScript() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicyScript";
    }

    /**
     * <i>“Device compliance script Id.”</i>
     * 
     * @return property deviceComplianceScriptId
     */
    @Property(name="deviceComplianceScriptId")
    @JsonIgnore
    public Optional<String> getDeviceComplianceScriptId() {
        return Optional.ofNullable(deviceComplianceScriptId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceScriptId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device compliance script Id.”</i>
     * 
     * @param deviceComplianceScriptId
     *            new value of {@code deviceComplianceScriptId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceScriptId} field changed
     */
    public DeviceCompliancePolicyScript withDeviceComplianceScriptId(String deviceComplianceScriptId) {
        DeviceCompliancePolicyScript _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyScript");
        _x.deviceComplianceScriptId = deviceComplianceScriptId;
        return _x;
    }

    /**
     * <i>“Json of the rules.”</i>
     * 
     * @return property rulesContent
     */
    @Property(name="rulesContent")
    @JsonIgnore
    public Optional<byte[]> getRulesContent() {
        return Optional.ofNullable(rulesContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rulesContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Json of the rules.”</i>
     * 
     * @param rulesContent
     *            new value of {@code rulesContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rulesContent} field changed
     */
    public DeviceCompliancePolicyScript withRulesContent(byte[] rulesContent) {
        DeviceCompliancePolicyScript _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyScript");
        _x.rulesContent = rulesContent;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceComplianceScriptId;
        private byte[] rulesContent;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device compliance script Id.”</i>
         * 
         * @param deviceComplianceScriptId
         *            value of {@code deviceComplianceScriptId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScriptId(String deviceComplianceScriptId) {
            this.deviceComplianceScriptId = deviceComplianceScriptId;
            this.changedFields = changedFields.add("deviceComplianceScriptId");
            return this;
        }

        /**
         * <i>“Json of the rules.”</i>
         * 
         * @param rulesContent
         *            value of {@code rulesContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rulesContent(byte[] rulesContent) {
            this.rulesContent = rulesContent;
            this.changedFields = changedFields.add("rulesContent");
            return this;
        }

        public DeviceCompliancePolicyScript build() {
            DeviceCompliancePolicyScript _x = new DeviceCompliancePolicyScript();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceCompliancePolicyScript";
            _x.deviceComplianceScriptId = deviceComplianceScriptId;
            _x.rulesContent = rulesContent;
            return _x;
        }
    }

    private DeviceCompliancePolicyScript _copy() {
        DeviceCompliancePolicyScript _x = new DeviceCompliancePolicyScript();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceComplianceScriptId = deviceComplianceScriptId;
        _x.rulesContent = rulesContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicyScript[");
        b.append("deviceComplianceScriptId=");
        b.append(this.deviceComplianceScriptId);
        b.append(", ");
        b.append("rulesContent=");
        b.append(this.rulesContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
