package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;


/**
 * <i>“Base type for assignment targets.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceAndAppManagementAssignmentFilterId", 
    "deviceAndAppManagementAssignmentFilterType"})
@JsonInclude(Include.NON_NULL)
public class DeviceAndAppManagementAssignmentTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceAndAppManagementAssignmentFilterId")
    protected String deviceAndAppManagementAssignmentFilterId;

    @JsonProperty("deviceAndAppManagementAssignmentFilterType")
    protected DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType;

    protected DeviceAndAppManagementAssignmentTarget() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAndAppManagementAssignmentTarget";
    }

    /**
     * <i>“The Id of the filter for the target assignment.”</i>
     * 
     * @return property deviceAndAppManagementAssignmentFilterId
     */
    @Property(name="deviceAndAppManagementAssignmentFilterId")
    @JsonIgnore
    public Optional<String> getDeviceAndAppManagementAssignmentFilterId() {
        return Optional.ofNullable(deviceAndAppManagementAssignmentFilterId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceAndAppManagementAssignmentFilterId} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The Id of the filter for the target assignment.”</i>
     * 
     * @param deviceAndAppManagementAssignmentFilterId
     *            new value of {@code deviceAndAppManagementAssignmentFilterId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceAndAppManagementAssignmentFilterId} field changed
     */
    public DeviceAndAppManagementAssignmentTarget withDeviceAndAppManagementAssignmentFilterId(String deviceAndAppManagementAssignmentFilterId) {
        DeviceAndAppManagementAssignmentTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentTarget");
        _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
        return _x;
    }

    /**
     * <i>“The type of filter of the target assignment i.e. Exclude or Include.”</i>
     * 
     * @return property deviceAndAppManagementAssignmentFilterType
     */
    @Property(name="deviceAndAppManagementAssignmentFilterType")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentFilterType> getDeviceAndAppManagementAssignmentFilterType() {
        return Optional.ofNullable(deviceAndAppManagementAssignmentFilterType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceAndAppManagementAssignmentFilterType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The type of filter of the target assignment i.e. Exclude or Include.”</i>
     * 
     * @param deviceAndAppManagementAssignmentFilterType
     *            new value of {@code deviceAndAppManagementAssignmentFilterType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceAndAppManagementAssignmentFilterType} field changed
     */
    public DeviceAndAppManagementAssignmentTarget withDeviceAndAppManagementAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType) {
        DeviceAndAppManagementAssignmentTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentTarget");
        _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceAndAppManagementAssignmentTarget _copy() {
        DeviceAndAppManagementAssignmentTarget _x = new DeviceAndAppManagementAssignmentTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
        _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAndAppManagementAssignmentTarget[");
        b.append("deviceAndAppManagementAssignmentFilterId=");
        b.append(this.deviceAndAppManagementAssignmentFilterId);
        b.append(", ");
        b.append("deviceAndAppManagementAssignmentFilterType=");
        b.append(this.deviceAndAppManagementAssignmentFilterType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
