package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "displayName", 
    "uniqueCount", 
    "confidence", 
    "recommendedConfidence", 
    "matches"})
@JsonInclude(Include.NON_NULL)
public class DetectedSensitiveContentBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("uniqueCount")
    protected Integer uniqueCount;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("recommendedConfidence")
    protected Integer recommendedConfidence;

    @JsonProperty("matches")
    protected List<SensitiveContentLocation> matches;

    @JsonProperty("matches@nextLink")
    protected String matchesNextLink;

    protected DetectedSensitiveContentBase() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedSensitiveContentBase";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public DetectedSensitiveContentBase withId(String id) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.id = id;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DetectedSensitiveContentBase withDisplayName(String displayName) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="uniqueCount")
    @JsonIgnore
    public Optional<Integer> getUniqueCount() {
        return Optional.ofNullable(uniqueCount);
    }

    public DetectedSensitiveContentBase withUniqueCount(Integer uniqueCount) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.uniqueCount = uniqueCount;
        return _x;
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public DetectedSensitiveContentBase withConfidence(Integer confidence) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="recommendedConfidence")
    @JsonIgnore
    public Optional<Integer> getRecommendedConfidence() {
        return Optional.ofNullable(recommendedConfidence);
    }

    public DetectedSensitiveContentBase withRecommendedConfidence(Integer recommendedConfidence) {
        DetectedSensitiveContentBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContentBase");
        _x.recommendedConfidence = recommendedConfidence;
        return _x;
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches() {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, matches, Optional.ofNullable(matchesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches(HttpRequestOptions options) {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, matches, Optional.ofNullable(matchesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Integer uniqueCount;
        private Integer confidence;
        private Integer recommendedConfidence;
        private List<SensitiveContentLocation> matches;
        private String matchesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder matches(List<SensitiveContentLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(SensitiveContentLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public DetectedSensitiveContentBase build() {
            DetectedSensitiveContentBase _x = new DetectedSensitiveContentBase();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.detectedSensitiveContentBase";
            _x.id = id;
            _x.displayName = displayName;
            _x.uniqueCount = uniqueCount;
            _x.confidence = confidence;
            _x.recommendedConfidence = recommendedConfidence;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            return _x;
        }
    }

    private DetectedSensitiveContentBase _copy() {
        DetectedSensitiveContentBase _x = new DetectedSensitiveContentBase();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.uniqueCount = uniqueCount;
        _x.confidence = confidence;
        _x.recommendedConfidence = recommendedConfidence;
        _x.matches = matches;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedSensitiveContentBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
