package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SensitiveTypeScope;

@JsonPropertyOrder({
    "@odata.type", 
    "scope"})
@JsonInclude(Include.NON_NULL)
public class DetectedSensitiveContent extends DetectedSensitiveContentBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("scope")
    protected SensitiveTypeScope scope;

    protected DetectedSensitiveContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedSensitiveContent";
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<SensitiveTypeScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public DetectedSensitiveContent withScope(SensitiveTypeScope scope) {
        DetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContent");
        _x.scope = scope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDetectedSensitiveContent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Integer uniqueCount;
        private Integer confidence;
        private Integer recommendedConfidence;
        private List<SensitiveContentLocation> matches;
        private String matchesNextLink;
        private SensitiveTypeScope scope;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder matches(List<SensitiveContentLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(SensitiveContentLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder scope(SensitiveTypeScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public DetectedSensitiveContent build() {
            DetectedSensitiveContent _x = new DetectedSensitiveContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.detectedSensitiveContent";
            _x.id = id;
            _x.displayName = displayName;
            _x.uniqueCount = uniqueCount;
            _x.confidence = confidence;
            _x.recommendedConfidence = recommendedConfidence;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            _x.scope = scope;
            return _x;
        }
    }

    private DetectedSensitiveContent _copy() {
        DetectedSensitiveContent _x = new DetectedSensitiveContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.uniqueCount = uniqueCount;
        _x.confidence = confidence;
        _x.recommendedConfidence = recommendedConfidence;
        _x.matches = matches;
        _x.scope = scope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedSensitiveContent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
