package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Delivery Optimization Max cache size percentage types.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maximumCacheSizePercentage"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationMaxCacheSizePercentage extends DeliveryOptimizationMaxCacheSize implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("maximumCacheSizePercentage")
    protected Integer maximumCacheSizePercentage;

    protected DeliveryOptimizationMaxCacheSizePercentage() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationMaxCacheSizePercentage";
    }

    /**
     * <i>“Specifies the maximum cache size that Delivery Optimization can utilize, as a
     * percentage of disk size (1-100). Valid values 1 to 100”</i>
     * 
     * @return property maximumCacheSizePercentage
     */
    @Property(name="maximumCacheSizePercentage")
    @JsonIgnore
    public Optional<Integer> getMaximumCacheSizePercentage() {
        return Optional.ofNullable(maximumCacheSizePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumCacheSizePercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the maximum cache size that Delivery Optimization can utilize, as a
     * percentage of disk size (1-100). Valid values 1 to 100”</i>
     * 
     * @param maximumCacheSizePercentage
     *            new value of {@code maximumCacheSizePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumCacheSizePercentage} field changed
     */
    public DeliveryOptimizationMaxCacheSizePercentage withMaximumCacheSizePercentage(Integer maximumCacheSizePercentage) {
        DeliveryOptimizationMaxCacheSizePercentage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationMaxCacheSizePercentage");
        _x.maximumCacheSizePercentage = maximumCacheSizePercentage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationMaxCacheSizePercentage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maximumCacheSizePercentage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Specifies the maximum cache size that Delivery Optimization can utilize, as a
         * percentage of disk size (1-100). Valid values 1 to 100”</i>
         * 
         * @param maximumCacheSizePercentage
         *            value of {@code maximumCacheSizePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumCacheSizePercentage(Integer maximumCacheSizePercentage) {
            this.maximumCacheSizePercentage = maximumCacheSizePercentage;
            this.changedFields = changedFields.add("maximumCacheSizePercentage");
            return this;
        }

        public DeliveryOptimizationMaxCacheSizePercentage build() {
            DeliveryOptimizationMaxCacheSizePercentage _x = new DeliveryOptimizationMaxCacheSizePercentage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationMaxCacheSizePercentage";
            _x.maximumCacheSizePercentage = maximumCacheSizePercentage;
            return _x;
        }
    }

    private DeliveryOptimizationMaxCacheSizePercentage _copy() {
        DeliveryOptimizationMaxCacheSizePercentage _x = new DeliveryOptimizationMaxCacheSizePercentage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.maximumCacheSizePercentage = maximumCacheSizePercentage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationMaxCacheSizePercentage[");
        b.append("maximumCacheSizePercentage=");
        b.append(this.maximumCacheSizePercentage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
