package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Delivery Optimization max cache size absolute type.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maximumCacheSizeInGigabytes"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationMaxCacheSizeAbsolute extends DeliveryOptimizationMaxCacheSize implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("maximumCacheSizeInGigabytes")
    protected Long maximumCacheSizeInGigabytes;

    protected DeliveryOptimizationMaxCacheSizeAbsolute() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationMaxCacheSizeAbsolute";
    }

    /**
     * <i>“The value 0 (zero) means "unlimited" cache. Delivery Optimization will clear the
     * cache when the device is running low on disk space. Valid values 0 to 4294967295”</i>
     * 
     * @return property maximumCacheSizeInGigabytes
     */
    @Property(name="maximumCacheSizeInGigabytes")
    @JsonIgnore
    public Optional<Long> getMaximumCacheSizeInGigabytes() {
        return Optional.ofNullable(maximumCacheSizeInGigabytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumCacheSizeInGigabytes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The value 0 (zero) means "unlimited" cache. Delivery Optimization will clear the
     * cache when the device is running low on disk space. Valid values 0 to 4294967295”</i>
     * 
     * @param maximumCacheSizeInGigabytes
     *            new value of {@code maximumCacheSizeInGigabytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumCacheSizeInGigabytes} field changed
     */
    public DeliveryOptimizationMaxCacheSizeAbsolute withMaximumCacheSizeInGigabytes(Long maximumCacheSizeInGigabytes) {
        DeliveryOptimizationMaxCacheSizeAbsolute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationMaxCacheSizeAbsolute");
        _x.maximumCacheSizeInGigabytes = maximumCacheSizeInGigabytes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationMaxCacheSizeAbsolute() {
        return new Builder();
    }

    public static final class Builder {
        private Long maximumCacheSizeInGigabytes;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The value 0 (zero) means "unlimited" cache. Delivery Optimization will clear the
         * cache when the device is running low on disk space. Valid values 0 to 4294967295”</i>
         * 
         * @param maximumCacheSizeInGigabytes
         *            value of {@code maximumCacheSizeInGigabytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumCacheSizeInGigabytes(Long maximumCacheSizeInGigabytes) {
            this.maximumCacheSizeInGigabytes = maximumCacheSizeInGigabytes;
            this.changedFields = changedFields.add("maximumCacheSizeInGigabytes");
            return this;
        }

        public DeliveryOptimizationMaxCacheSizeAbsolute build() {
            DeliveryOptimizationMaxCacheSizeAbsolute _x = new DeliveryOptimizationMaxCacheSizeAbsolute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationMaxCacheSizeAbsolute";
            _x.maximumCacheSizeInGigabytes = maximumCacheSizeInGigabytes;
            return _x;
        }
    }

    private DeliveryOptimizationMaxCacheSizeAbsolute _copy() {
        DeliveryOptimizationMaxCacheSizeAbsolute _x = new DeliveryOptimizationMaxCacheSizeAbsolute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.maximumCacheSizeInGigabytes = maximumCacheSizeInGigabytes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationMaxCacheSizeAbsolute[");
        b.append("maximumCacheSizeInGigabytes=");
        b.append(this.maximumCacheSizeInGigabytes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
