package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Custom group id type”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupIdCustom"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationGroupIdCustom extends DeliveryOptimizationGroupIdSource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("groupIdCustom")
    protected String groupIdCustom;

    protected DeliveryOptimizationGroupIdCustom() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationGroupIdCustom";
    }

    /**
     * <i>“Specifies an arbitrary group ID that the device belongs to”</i>
     * 
     * @return property groupIdCustom
     */
    @Property(name="groupIdCustom")
    @JsonIgnore
    public Optional<String> getGroupIdCustom() {
        return Optional.ofNullable(groupIdCustom);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupIdCustom}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies an arbitrary group ID that the device belongs to”</i>
     * 
     * @param groupIdCustom
     *            new value of {@code groupIdCustom} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupIdCustom} field changed
     */
    public DeliveryOptimizationGroupIdCustom withGroupIdCustom(String groupIdCustom) {
        DeliveryOptimizationGroupIdCustom _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationGroupIdCustom");
        _x.groupIdCustom = groupIdCustom;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationGroupIdCustom() {
        return new Builder();
    }

    public static final class Builder {
        private String groupIdCustom;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Specifies an arbitrary group ID that the device belongs to”</i>
         * 
         * @param groupIdCustom
         *            value of {@code groupIdCustom} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupIdCustom(String groupIdCustom) {
            this.groupIdCustom = groupIdCustom;
            this.changedFields = changedFields.add("groupIdCustom");
            return this;
        }

        public DeliveryOptimizationGroupIdCustom build() {
            DeliveryOptimizationGroupIdCustom _x = new DeliveryOptimizationGroupIdCustom();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationGroupIdCustom";
            _x.groupIdCustom = groupIdCustom;
            return _x;
        }
    }

    private DeliveryOptimizationGroupIdCustom _copy() {
        DeliveryOptimizationGroupIdCustom _x = new DeliveryOptimizationGroupIdCustom();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.groupIdCustom = groupIdCustom;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationGroupIdCustom[");
        b.append("groupIdCustom=");
        b.append(this.groupIdCustom);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
