package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Bandwidth limits specified as a percentage.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maximumBackgroundBandwidthPercentage", 
    "maximumForegroundBandwidthPercentage"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationBandwidthPercentage extends DeliveryOptimizationBandwidth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("maximumBackgroundBandwidthPercentage")
    protected Integer maximumBackgroundBandwidthPercentage;

    @JsonProperty("maximumForegroundBandwidthPercentage")
    protected Integer maximumForegroundBandwidthPercentage;

    protected DeliveryOptimizationBandwidthPercentage() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationBandwidthPercentage";
    }

    /**
     * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
     * to use the available bandwidth for background downloads. Valid values 0 to 100”</i>
     * 
     * @return property maximumBackgroundBandwidthPercentage
     */
    @Property(name="maximumBackgroundBandwidthPercentage")
    @JsonIgnore
    public Optional<Integer> getMaximumBackgroundBandwidthPercentage() {
        return Optional.ofNullable(maximumBackgroundBandwidthPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumBackgroundBandwidthPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
     * to use the available bandwidth for background downloads. Valid values 0 to 100”</i>
     * 
     * @param maximumBackgroundBandwidthPercentage
     *            new value of {@code maximumBackgroundBandwidthPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumBackgroundBandwidthPercentage} field changed
     */
    public DeliveryOptimizationBandwidthPercentage withMaximumBackgroundBandwidthPercentage(Integer maximumBackgroundBandwidthPercentage) {
        DeliveryOptimizationBandwidthPercentage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthPercentage");
        _x.maximumBackgroundBandwidthPercentage = maximumBackgroundBandwidthPercentage;
        return _x;
    }

    /**
     * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
     * to use the available bandwidth for foreground downloads. Valid values 0 to 100”</i>
     * 
     * @return property maximumForegroundBandwidthPercentage
     */
    @Property(name="maximumForegroundBandwidthPercentage")
    @JsonIgnore
    public Optional<Integer> getMaximumForegroundBandwidthPercentage() {
        return Optional.ofNullable(maximumForegroundBandwidthPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumForegroundBandwidthPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
     * to use the available bandwidth for foreground downloads. Valid values 0 to 100”</i>
     * 
     * @param maximumForegroundBandwidthPercentage
     *            new value of {@code maximumForegroundBandwidthPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumForegroundBandwidthPercentage} field changed
     */
    public DeliveryOptimizationBandwidthPercentage withMaximumForegroundBandwidthPercentage(Integer maximumForegroundBandwidthPercentage) {
        DeliveryOptimizationBandwidthPercentage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthPercentage");
        _x.maximumForegroundBandwidthPercentage = maximumForegroundBandwidthPercentage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationBandwidthPercentage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maximumBackgroundBandwidthPercentage;
        private Integer maximumForegroundBandwidthPercentage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
         * to use the available bandwidth for background downloads. Valid values 0 to 100”</i>
         * 
         * @param maximumBackgroundBandwidthPercentage
         *            value of {@code maximumBackgroundBandwidthPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumBackgroundBandwidthPercentage(Integer maximumBackgroundBandwidthPercentage) {
            this.maximumBackgroundBandwidthPercentage = maximumBackgroundBandwidthPercentage;
            this.changedFields = changedFields.add("maximumBackgroundBandwidthPercentage");
            return this;
        }

        /**
         * <i>“The default value 0 (zero) means that Delivery Optimization dynamically adjusts
         * to use the available bandwidth for foreground downloads. Valid values 0 to 100”</i>
         * 
         * @param maximumForegroundBandwidthPercentage
         *            value of {@code maximumForegroundBandwidthPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumForegroundBandwidthPercentage(Integer maximumForegroundBandwidthPercentage) {
            this.maximumForegroundBandwidthPercentage = maximumForegroundBandwidthPercentage;
            this.changedFields = changedFields.add("maximumForegroundBandwidthPercentage");
            return this;
        }

        public DeliveryOptimizationBandwidthPercentage build() {
            DeliveryOptimizationBandwidthPercentage _x = new DeliveryOptimizationBandwidthPercentage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationBandwidthPercentage";
            _x.maximumBackgroundBandwidthPercentage = maximumBackgroundBandwidthPercentage;
            _x.maximumForegroundBandwidthPercentage = maximumForegroundBandwidthPercentage;
            return _x;
        }
    }

    private DeliveryOptimizationBandwidthPercentage _copy() {
        DeliveryOptimizationBandwidthPercentage _x = new DeliveryOptimizationBandwidthPercentage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.maximumBackgroundBandwidthPercentage = maximumBackgroundBandwidthPercentage;
        _x.maximumForegroundBandwidthPercentage = maximumForegroundBandwidthPercentage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationBandwidthPercentage[");
        b.append("maximumBackgroundBandwidthPercentage=");
        b.append(this.maximumBackgroundBandwidthPercentage);
        b.append(", ");
        b.append("maximumForegroundBandwidthPercentage=");
        b.append(this.maximumForegroundBandwidthPercentage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
