package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Bandwidth limit as a percentage with business hours.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bandwidthBackgroundPercentageHours", 
    "bandwidthForegroundPercentageHours"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationBandwidthHoursWithPercentage extends DeliveryOptimizationBandwidth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("bandwidthBackgroundPercentageHours")
    protected DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthBackgroundPercentageHours;

    @JsonProperty("bandwidthForegroundPercentageHours")
    protected DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthForegroundPercentageHours;

    protected DeliveryOptimizationBandwidthHoursWithPercentage() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationBandwidthHoursWithPercentage";
    }

    /**
     * <i>“Background download percentage hours.”</i>
     * 
     * @return property bandwidthBackgroundPercentageHours
     */
    @Property(name="bandwidthBackgroundPercentageHours")
    @JsonIgnore
    public Optional<DeliveryOptimizationBandwidthBusinessHoursLimit> getBandwidthBackgroundPercentageHours() {
        return Optional.ofNullable(bandwidthBackgroundPercentageHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthBackgroundPercentageHours} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Background download percentage hours.”</i>
     * 
     * @param bandwidthBackgroundPercentageHours
     *            new value of {@code bandwidthBackgroundPercentageHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthBackgroundPercentageHours} field changed
     */
    public DeliveryOptimizationBandwidthHoursWithPercentage withBandwidthBackgroundPercentageHours(DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthBackgroundPercentageHours) {
        DeliveryOptimizationBandwidthHoursWithPercentage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthHoursWithPercentage");
        _x.bandwidthBackgroundPercentageHours = bandwidthBackgroundPercentageHours;
        return _x;
    }

    /**
     * <i>“Foreground download percentage hours.”</i>
     * 
     * @return property bandwidthForegroundPercentageHours
     */
    @Property(name="bandwidthForegroundPercentageHours")
    @JsonIgnore
    public Optional<DeliveryOptimizationBandwidthBusinessHoursLimit> getBandwidthForegroundPercentageHours() {
        return Optional.ofNullable(bandwidthForegroundPercentageHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthForegroundPercentageHours} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Foreground download percentage hours.”</i>
     * 
     * @param bandwidthForegroundPercentageHours
     *            new value of {@code bandwidthForegroundPercentageHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthForegroundPercentageHours} field changed
     */
    public DeliveryOptimizationBandwidthHoursWithPercentage withBandwidthForegroundPercentageHours(DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthForegroundPercentageHours) {
        DeliveryOptimizationBandwidthHoursWithPercentage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthHoursWithPercentage");
        _x.bandwidthForegroundPercentageHours = bandwidthForegroundPercentageHours;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationBandwidthHoursWithPercentage() {
        return new Builder();
    }

    public static final class Builder {
        private DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthBackgroundPercentageHours;
        private DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthForegroundPercentageHours;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Background download percentage hours.”</i>
         * 
         * @param bandwidthBackgroundPercentageHours
         *            value of {@code bandwidthBackgroundPercentageHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthBackgroundPercentageHours(DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthBackgroundPercentageHours) {
            this.bandwidthBackgroundPercentageHours = bandwidthBackgroundPercentageHours;
            this.changedFields = changedFields.add("bandwidthBackgroundPercentageHours");
            return this;
        }

        /**
         * <i>“Foreground download percentage hours.”</i>
         * 
         * @param bandwidthForegroundPercentageHours
         *            value of {@code bandwidthForegroundPercentageHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthForegroundPercentageHours(DeliveryOptimizationBandwidthBusinessHoursLimit bandwidthForegroundPercentageHours) {
            this.bandwidthForegroundPercentageHours = bandwidthForegroundPercentageHours;
            this.changedFields = changedFields.add("bandwidthForegroundPercentageHours");
            return this;
        }

        public DeliveryOptimizationBandwidthHoursWithPercentage build() {
            DeliveryOptimizationBandwidthHoursWithPercentage _x = new DeliveryOptimizationBandwidthHoursWithPercentage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationBandwidthHoursWithPercentage";
            _x.bandwidthBackgroundPercentageHours = bandwidthBackgroundPercentageHours;
            _x.bandwidthForegroundPercentageHours = bandwidthForegroundPercentageHours;
            return _x;
        }
    }

    private DeliveryOptimizationBandwidthHoursWithPercentage _copy() {
        DeliveryOptimizationBandwidthHoursWithPercentage _x = new DeliveryOptimizationBandwidthHoursWithPercentage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.bandwidthBackgroundPercentageHours = bandwidthBackgroundPercentageHours;
        _x.bandwidthForegroundPercentageHours = bandwidthForegroundPercentageHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationBandwidthHoursWithPercentage[");
        b.append("bandwidthBackgroundPercentageHours=");
        b.append(this.bandwidthBackgroundPercentageHours);
        b.append(", ");
        b.append("bandwidthForegroundPercentageHours=");
        b.append(this.bandwidthForegroundPercentageHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
