package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Bandwidth business hours and percentages type”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bandwidthBeginBusinessHours", 
    "bandwidthEndBusinessHours", 
    "bandwidthPercentageDuringBusinessHours", 
    "bandwidthPercentageOutsideBusinessHours"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationBandwidthBusinessHoursLimit implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bandwidthBeginBusinessHours")
    protected Integer bandwidthBeginBusinessHours;

    @JsonProperty("bandwidthEndBusinessHours")
    protected Integer bandwidthEndBusinessHours;

    @JsonProperty("bandwidthPercentageDuringBusinessHours")
    protected Integer bandwidthPercentageDuringBusinessHours;

    @JsonProperty("bandwidthPercentageOutsideBusinessHours")
    protected Integer bandwidthPercentageOutsideBusinessHours;

    protected DeliveryOptimizationBandwidthBusinessHoursLimit() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit";
    }

    /**
     * <i>“Specifies the beginning of business hours using a 24-hour clock (0-23). Valid
     * values 0 to 23”</i>
     * 
     * @return property bandwidthBeginBusinessHours
     */
    @Property(name="bandwidthBeginBusinessHours")
    @JsonIgnore
    public Optional<Integer> getBandwidthBeginBusinessHours() {
        return Optional.ofNullable(bandwidthBeginBusinessHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthBeginBusinessHours} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the beginning of business hours using a 24-hour clock (0-23). Valid
     * values 0 to 23”</i>
     * 
     * @param bandwidthBeginBusinessHours
     *            new value of {@code bandwidthBeginBusinessHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthBeginBusinessHours} field changed
     */
    public DeliveryOptimizationBandwidthBusinessHoursLimit withBandwidthBeginBusinessHours(Integer bandwidthBeginBusinessHours) {
        DeliveryOptimizationBandwidthBusinessHoursLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit");
        _x.bandwidthBeginBusinessHours = bandwidthBeginBusinessHours;
        return _x;
    }

    /**
     * <i>“Specifies the end of business hours using a 24-hour clock (0-23). Valid values 0
     * to 23”</i>
     * 
     * @return property bandwidthEndBusinessHours
     */
    @Property(name="bandwidthEndBusinessHours")
    @JsonIgnore
    public Optional<Integer> getBandwidthEndBusinessHours() {
        return Optional.ofNullable(bandwidthEndBusinessHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthEndBusinessHours} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the end of business hours using a 24-hour clock (0-23). Valid values 0
     * to 23”</i>
     * 
     * @param bandwidthEndBusinessHours
     *            new value of {@code bandwidthEndBusinessHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthEndBusinessHours} field changed
     */
    public DeliveryOptimizationBandwidthBusinessHoursLimit withBandwidthEndBusinessHours(Integer bandwidthEndBusinessHours) {
        DeliveryOptimizationBandwidthBusinessHoursLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit");
        _x.bandwidthEndBusinessHours = bandwidthEndBusinessHours;
        return _x;
    }

    /**
     * <i>“Specifies the percentage of bandwidth to limit during business hours (0-100).
     * Valid values 0 to 100”</i>
     * 
     * @return property bandwidthPercentageDuringBusinessHours
     */
    @Property(name="bandwidthPercentageDuringBusinessHours")
    @JsonIgnore
    public Optional<Integer> getBandwidthPercentageDuringBusinessHours() {
        return Optional.ofNullable(bandwidthPercentageDuringBusinessHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthPercentageDuringBusinessHours} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the percentage of bandwidth to limit during business hours (0-100).
     * Valid values 0 to 100”</i>
     * 
     * @param bandwidthPercentageDuringBusinessHours
     *            new value of {@code bandwidthPercentageDuringBusinessHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthPercentageDuringBusinessHours} field changed
     */
    public DeliveryOptimizationBandwidthBusinessHoursLimit withBandwidthPercentageDuringBusinessHours(Integer bandwidthPercentageDuringBusinessHours) {
        DeliveryOptimizationBandwidthBusinessHoursLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit");
        _x.bandwidthPercentageDuringBusinessHours = bandwidthPercentageDuringBusinessHours;
        return _x;
    }

    /**
     * <i>“Specifies the percentage of bandwidth to limit outsidse business hours (0-100).
     * Valid values 0 to 100”</i>
     * 
     * @return property bandwidthPercentageOutsideBusinessHours
     */
    @Property(name="bandwidthPercentageOutsideBusinessHours")
    @JsonIgnore
    public Optional<Integer> getBandwidthPercentageOutsideBusinessHours() {
        return Optional.ofNullable(bandwidthPercentageOutsideBusinessHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bandwidthPercentageOutsideBusinessHours} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the percentage of bandwidth to limit outsidse business hours (0-100).
     * Valid values 0 to 100”</i>
     * 
     * @param bandwidthPercentageOutsideBusinessHours
     *            new value of {@code bandwidthPercentageOutsideBusinessHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthPercentageOutsideBusinessHours} field changed
     */
    public DeliveryOptimizationBandwidthBusinessHoursLimit withBandwidthPercentageOutsideBusinessHours(Integer bandwidthPercentageOutsideBusinessHours) {
        DeliveryOptimizationBandwidthBusinessHoursLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit");
        _x.bandwidthPercentageOutsideBusinessHours = bandwidthPercentageOutsideBusinessHours;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer bandwidthBeginBusinessHours;
        private Integer bandwidthEndBusinessHours;
        private Integer bandwidthPercentageDuringBusinessHours;
        private Integer bandwidthPercentageOutsideBusinessHours;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Specifies the beginning of business hours using a 24-hour clock (0-23). Valid
         * values 0 to 23”</i>
         * 
         * @param bandwidthBeginBusinessHours
         *            value of {@code bandwidthBeginBusinessHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthBeginBusinessHours(Integer bandwidthBeginBusinessHours) {
            this.bandwidthBeginBusinessHours = bandwidthBeginBusinessHours;
            this.changedFields = changedFields.add("bandwidthBeginBusinessHours");
            return this;
        }

        /**
         * <i>“Specifies the end of business hours using a 24-hour clock (0-23). Valid values 0
         * to 23”</i>
         * 
         * @param bandwidthEndBusinessHours
         *            value of {@code bandwidthEndBusinessHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthEndBusinessHours(Integer bandwidthEndBusinessHours) {
            this.bandwidthEndBusinessHours = bandwidthEndBusinessHours;
            this.changedFields = changedFields.add("bandwidthEndBusinessHours");
            return this;
        }

        /**
         * <i>“Specifies the percentage of bandwidth to limit during business hours (0-100).
         * Valid values 0 to 100”</i>
         * 
         * @param bandwidthPercentageDuringBusinessHours
         *            value of {@code bandwidthPercentageDuringBusinessHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthPercentageDuringBusinessHours(Integer bandwidthPercentageDuringBusinessHours) {
            this.bandwidthPercentageDuringBusinessHours = bandwidthPercentageDuringBusinessHours;
            this.changedFields = changedFields.add("bandwidthPercentageDuringBusinessHours");
            return this;
        }

        /**
         * <i>“Specifies the percentage of bandwidth to limit outsidse business hours (0-100).
         * Valid values 0 to 100”</i>
         * 
         * @param bandwidthPercentageOutsideBusinessHours
         *            value of {@code bandwidthPercentageOutsideBusinessHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthPercentageOutsideBusinessHours(Integer bandwidthPercentageOutsideBusinessHours) {
            this.bandwidthPercentageOutsideBusinessHours = bandwidthPercentageOutsideBusinessHours;
            this.changedFields = changedFields.add("bandwidthPercentageOutsideBusinessHours");
            return this;
        }

        public DeliveryOptimizationBandwidthBusinessHoursLimit build() {
            DeliveryOptimizationBandwidthBusinessHoursLimit _x = new DeliveryOptimizationBandwidthBusinessHoursLimit();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationBandwidthBusinessHoursLimit";
            _x.bandwidthBeginBusinessHours = bandwidthBeginBusinessHours;
            _x.bandwidthEndBusinessHours = bandwidthEndBusinessHours;
            _x.bandwidthPercentageDuringBusinessHours = bandwidthPercentageDuringBusinessHours;
            _x.bandwidthPercentageOutsideBusinessHours = bandwidthPercentageOutsideBusinessHours;
            return _x;
        }
    }

    private DeliveryOptimizationBandwidthBusinessHoursLimit _copy() {
        DeliveryOptimizationBandwidthBusinessHoursLimit _x = new DeliveryOptimizationBandwidthBusinessHoursLimit();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.bandwidthBeginBusinessHours = bandwidthBeginBusinessHours;
        _x.bandwidthEndBusinessHours = bandwidthEndBusinessHours;
        _x.bandwidthPercentageDuringBusinessHours = bandwidthPercentageDuringBusinessHours;
        _x.bandwidthPercentageOutsideBusinessHours = bandwidthPercentageOutsideBusinessHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationBandwidthBusinessHoursLimit[");
        b.append("bandwidthBeginBusinessHours=");
        b.append(this.bandwidthBeginBusinessHours);
        b.append(", ");
        b.append("bandwidthEndBusinessHours=");
        b.append(this.bandwidthEndBusinessHours);
        b.append(", ");
        b.append("bandwidthPercentageDuringBusinessHours=");
        b.append(this.bandwidthPercentageDuringBusinessHours);
        b.append(", ");
        b.append("bandwidthPercentageOutsideBusinessHours=");
        b.append(this.bandwidthPercentageOutsideBusinessHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
