package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Bandwidth limits in kilobytes per second.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maximumDownloadBandwidthInKilobytesPerSecond", 
    "maximumUploadBandwidthInKilobytesPerSecond"})
@JsonInclude(Include.NON_NULL)
public class DeliveryOptimizationBandwidthAbsolute extends DeliveryOptimizationBandwidth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("maximumDownloadBandwidthInKilobytesPerSecond")
    protected Long maximumDownloadBandwidthInKilobytesPerSecond;

    @JsonProperty("maximumUploadBandwidthInKilobytesPerSecond")
    protected Long maximumUploadBandwidthInKilobytesPerSecond;

    protected DeliveryOptimizationBandwidthAbsolute() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deliveryOptimizationBandwidthAbsolute";
    }

    /**
     * <i>“The value 0 (zero) means that Delivery Optimization dynamically adjusts to use
     * the available bandwidth for downloads. Valid values 0 to 4294967295”</i>
     * 
     * @return property maximumDownloadBandwidthInKilobytesPerSecond
     */
    @Property(name="maximumDownloadBandwidthInKilobytesPerSecond")
    @JsonIgnore
    public Optional<Long> getMaximumDownloadBandwidthInKilobytesPerSecond() {
        return Optional.ofNullable(maximumDownloadBandwidthInKilobytesPerSecond);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumDownloadBandwidthInKilobytesPerSecond} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The value 0 (zero) means that Delivery Optimization dynamically adjusts to use
     * the available bandwidth for downloads. Valid values 0 to 4294967295”</i>
     * 
     * @param maximumDownloadBandwidthInKilobytesPerSecond
     *            new value of {@code maximumDownloadBandwidthInKilobytesPerSecond} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumDownloadBandwidthInKilobytesPerSecond} field changed
     */
    public DeliveryOptimizationBandwidthAbsolute withMaximumDownloadBandwidthInKilobytesPerSecond(Long maximumDownloadBandwidthInKilobytesPerSecond) {
        DeliveryOptimizationBandwidthAbsolute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthAbsolute");
        _x.maximumDownloadBandwidthInKilobytesPerSecond = maximumDownloadBandwidthInKilobytesPerSecond;
        return _x;
    }

    /**
     * <i>“The default value is 0, which permits unlimited possible bandwidth (optimized
     * for minimal usage of upload bandwidth). Valid values 0 to 4000000”</i>
     * 
     * @return property maximumUploadBandwidthInKilobytesPerSecond
     */
    @Property(name="maximumUploadBandwidthInKilobytesPerSecond")
    @JsonIgnore
    public Optional<Long> getMaximumUploadBandwidthInKilobytesPerSecond() {
        return Optional.ofNullable(maximumUploadBandwidthInKilobytesPerSecond);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumUploadBandwidthInKilobytesPerSecond} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The default value is 0, which permits unlimited possible bandwidth (optimized
     * for minimal usage of upload bandwidth). Valid values 0 to 4000000”</i>
     * 
     * @param maximumUploadBandwidthInKilobytesPerSecond
     *            new value of {@code maximumUploadBandwidthInKilobytesPerSecond} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumUploadBandwidthInKilobytesPerSecond} field changed
     */
    public DeliveryOptimizationBandwidthAbsolute withMaximumUploadBandwidthInKilobytesPerSecond(Long maximumUploadBandwidthInKilobytesPerSecond) {
        DeliveryOptimizationBandwidthAbsolute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deliveryOptimizationBandwidthAbsolute");
        _x.maximumUploadBandwidthInKilobytesPerSecond = maximumUploadBandwidthInKilobytesPerSecond;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeliveryOptimizationBandwidthAbsolute() {
        return new Builder();
    }

    public static final class Builder {
        private Long maximumDownloadBandwidthInKilobytesPerSecond;
        private Long maximumUploadBandwidthInKilobytesPerSecond;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The value 0 (zero) means that Delivery Optimization dynamically adjusts to use
         * the available bandwidth for downloads. Valid values 0 to 4294967295”</i>
         * 
         * @param maximumDownloadBandwidthInKilobytesPerSecond
         *            value of {@code maximumDownloadBandwidthInKilobytesPerSecond} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumDownloadBandwidthInKilobytesPerSecond(Long maximumDownloadBandwidthInKilobytesPerSecond) {
            this.maximumDownloadBandwidthInKilobytesPerSecond = maximumDownloadBandwidthInKilobytesPerSecond;
            this.changedFields = changedFields.add("maximumDownloadBandwidthInKilobytesPerSecond");
            return this;
        }

        /**
         * <i>“The default value is 0, which permits unlimited possible bandwidth (optimized
         * for minimal usage of upload bandwidth). Valid values 0 to 4000000”</i>
         * 
         * @param maximumUploadBandwidthInKilobytesPerSecond
         *            value of {@code maximumUploadBandwidthInKilobytesPerSecond} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumUploadBandwidthInKilobytesPerSecond(Long maximumUploadBandwidthInKilobytesPerSecond) {
            this.maximumUploadBandwidthInKilobytesPerSecond = maximumUploadBandwidthInKilobytesPerSecond;
            this.changedFields = changedFields.add("maximumUploadBandwidthInKilobytesPerSecond");
            return this;
        }

        public DeliveryOptimizationBandwidthAbsolute build() {
            DeliveryOptimizationBandwidthAbsolute _x = new DeliveryOptimizationBandwidthAbsolute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deliveryOptimizationBandwidthAbsolute";
            _x.maximumDownloadBandwidthInKilobytesPerSecond = maximumDownloadBandwidthInKilobytesPerSecond;
            _x.maximumUploadBandwidthInKilobytesPerSecond = maximumUploadBandwidthInKilobytesPerSecond;
            return _x;
        }
    }

    private DeliveryOptimizationBandwidthAbsolute _copy() {
        DeliveryOptimizationBandwidthAbsolute _x = new DeliveryOptimizationBandwidthAbsolute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.maximumDownloadBandwidthInKilobytesPerSecond = maximumDownloadBandwidthInKilobytesPerSecond;
        _x.maximumUploadBandwidthInKilobytesPerSecond = maximumUploadBandwidthInKilobytesPerSecond;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeliveryOptimizationBandwidthAbsolute[");
        b.append("maximumDownloadBandwidthInKilobytesPerSecond=");
        b.append(this.maximumDownloadBandwidthInKilobytesPerSecond);
        b.append(", ");
        b.append("maximumUploadBandwidthInKilobytesPerSecond=");
        b.append(this.maximumUploadBandwidthInKilobytesPerSecond);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
