package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Delete user from shared apple device action result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class DeleteUserFromSharedAppleDeviceActionResult extends DeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected DeleteUserFromSharedAppleDeviceActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deleteUserFromSharedAppleDeviceActionResult";
    }

    /**
     * <i>“User principal name of the user to be deleted”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User principal name of the user to be deleted”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeleteUserFromSharedAppleDeviceActionResult withUserPrincipalName(String userPrincipalName) {
        DeleteUserFromSharedAppleDeviceActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deleteUserFromSharedAppleDeviceActionResult");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeleteUserFromSharedAppleDeviceActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“User principal name of the user to be deleted”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public DeleteUserFromSharedAppleDeviceActionResult build() {
            DeleteUserFromSharedAppleDeviceActionResult _x = new DeleteUserFromSharedAppleDeviceActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deleteUserFromSharedAppleDeviceActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private DeleteUserFromSharedAppleDeviceActionResult _copy() {
        DeleteUserFromSharedAppleDeviceActionResult _x = new DeleteUserFromSharedAppleDeviceActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeleteUserFromSharedAppleDeviceActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
